@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.ApiCorsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowCredentials Whether credentials are included in the CORS request.
 * @property allowHeaders Set of allowed HTTP headers.
 * @property allowMethods Set of allowed HTTP methods.
 * @property allowOrigins Set of allowed origins.
 * @property exposeHeaders Set of exposed HTTP headers.
 * @property maxAge Number of seconds that the browser should cache preflight request results.
 */
public data class ApiCorsConfigurationArgs(
    public val allowCredentials: Output<Boolean>? = null,
    public val allowHeaders: Output<List<String>>? = null,
    public val allowMethods: Output<List<String>>? = null,
    public val allowOrigins: Output<List<String>>? = null,
    public val exposeHeaders: Output<List<String>>? = null,
    public val maxAge: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.ApiCorsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.ApiCorsConfigurationArgs =
        com.pulumi.aws.apigatewayv2.inputs.ApiCorsConfigurationArgs.builder()
            .allowCredentials(allowCredentials?.applyValue({ args0 -> args0 }))
            .allowHeaders(allowHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowMethods(allowMethods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowOrigins(allowOrigins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposeHeaders(exposeHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAge(maxAge?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiCorsConfigurationArgs].
 */
@PulumiTagMarker
public class ApiCorsConfigurationArgsBuilder internal constructor() {
    private var allowCredentials: Output<Boolean>? = null

    private var allowHeaders: Output<List<String>>? = null

    private var allowMethods: Output<List<String>>? = null

    private var allowOrigins: Output<List<String>>? = null

    private var exposeHeaders: Output<List<String>>? = null

    private var maxAge: Output<Int>? = null

    /**
     * @param value Whether credentials are included in the CORS request.
     */
    @JvmName("pwmaiildfwshrkty")
    public suspend fun allowCredentials(`value`: Output<Boolean>) {
        this.allowCredentials = value
    }

    /**
     * @param value Set of allowed HTTP headers.
     */
    @JvmName("khdvyjxvlkauxcag")
    public suspend fun allowHeaders(`value`: Output<List<String>>) {
        this.allowHeaders = value
    }

    @JvmName("blwqpixtxxcawwmg")
    public suspend fun allowHeaders(vararg values: Output<String>) {
        this.allowHeaders = Output.all(values.asList())
    }

    /**
     * @param values Set of allowed HTTP headers.
     */
    @JvmName("syfjkkpfbqmkrugp")
    public suspend fun allowHeaders(values: List<Output<String>>) {
        this.allowHeaders = Output.all(values)
    }

    /**
     * @param value Set of allowed HTTP methods.
     */
    @JvmName("lveoiwrqxbgxpgqo")
    public suspend fun allowMethods(`value`: Output<List<String>>) {
        this.allowMethods = value
    }

    @JvmName("jxpxkamkuryejvnr")
    public suspend fun allowMethods(vararg values: Output<String>) {
        this.allowMethods = Output.all(values.asList())
    }

    /**
     * @param values Set of allowed HTTP methods.
     */
    @JvmName("mkwhayylxuwhslrw")
    public suspend fun allowMethods(values: List<Output<String>>) {
        this.allowMethods = Output.all(values)
    }

    /**
     * @param value Set of allowed origins.
     */
    @JvmName("blinrgeoqlkvbueq")
    public suspend fun allowOrigins(`value`: Output<List<String>>) {
        this.allowOrigins = value
    }

    @JvmName("ypeoxryqrhgytgrr")
    public suspend fun allowOrigins(vararg values: Output<String>) {
        this.allowOrigins = Output.all(values.asList())
    }

    /**
     * @param values Set of allowed origins.
     */
    @JvmName("kdgbyqjbquvlvvfi")
    public suspend fun allowOrigins(values: List<Output<String>>) {
        this.allowOrigins = Output.all(values)
    }

    /**
     * @param value Set of exposed HTTP headers.
     */
    @JvmName("oecoxmxjqnldkvwb")
    public suspend fun exposeHeaders(`value`: Output<List<String>>) {
        this.exposeHeaders = value
    }

    @JvmName("imfimdjwkbtaughx")
    public suspend fun exposeHeaders(vararg values: Output<String>) {
        this.exposeHeaders = Output.all(values.asList())
    }

    /**
     * @param values Set of exposed HTTP headers.
     */
    @JvmName("sefdqmugxstclyxk")
    public suspend fun exposeHeaders(values: List<Output<String>>) {
        this.exposeHeaders = Output.all(values)
    }

    /**
     * @param value Number of seconds that the browser should cache preflight request results.
     */
    @JvmName("nvapfauulkhwnnbc")
    public suspend fun maxAge(`value`: Output<Int>) {
        this.maxAge = value
    }

    /**
     * @param value Whether credentials are included in the CORS request.
     */
    @JvmName("klcfefucgcqemovt")
    public suspend fun allowCredentials(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCredentials = mapped
    }

    /**
     * @param value Set of allowed HTTP headers.
     */
    @JvmName("urhhwtcrgmlrchqp")
    public suspend fun allowHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowHeaders = mapped
    }

    /**
     * @param values Set of allowed HTTP headers.
     */
    @JvmName("elhrnofydcsymjia")
    public suspend fun allowHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowHeaders = mapped
    }

    /**
     * @param value Set of allowed HTTP methods.
     */
    @JvmName("slaypreffkyawrcl")
    public suspend fun allowMethods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowMethods = mapped
    }

    /**
     * @param values Set of allowed HTTP methods.
     */
    @JvmName("urvvxapavmfslguw")
    public suspend fun allowMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowMethods = mapped
    }

    /**
     * @param value Set of allowed origins.
     */
    @JvmName("vkixyllesnwyiqtx")
    public suspend fun allowOrigins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowOrigins = mapped
    }

    /**
     * @param values Set of allowed origins.
     */
    @JvmName("sevrpvhypkyqpaco")
    public suspend fun allowOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowOrigins = mapped
    }

    /**
     * @param value Set of exposed HTTP headers.
     */
    @JvmName("olxwcrvbqcaqciru")
    public suspend fun exposeHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param values Set of exposed HTTP headers.
     */
    @JvmName("bejoxxebdhfkyqac")
    public suspend fun exposeHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param value Number of seconds that the browser should cache preflight request results.
     */
    @JvmName("wscmtleeqtlohqwn")
    public suspend fun maxAge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAge = mapped
    }

    internal fun build(): ApiCorsConfigurationArgs = ApiCorsConfigurationArgs(
        allowCredentials = allowCredentials,
        allowHeaders = allowHeaders,
        allowMethods = allowMethods,
        allowOrigins = allowOrigins,
        exposeHeaders = exposeHeaders,
        maxAge = maxAge,
    )
}
