@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.DomainNameDomainNameConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateArn ARN of an AWS-managed certificate that will be used by the endpoint for the domain name. AWS Certificate Manager is the only supported source. Use the `aws.acm.Certificate` resource to configure an ACM certificate.
 * @property endpointType Endpoint type. Valid values: `REGIONAL`.
 * @property hostedZoneId Amazon Route 53 Hosted Zone ID of the endpoint.
 * @property ownershipVerificationCertificateArn ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
 * @property securityPolicy Transport Layer Security (TLS) version of the [security policy](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-custom-domain-tls-version.html) for the domain name. Valid values: `TLS_1_2`.
 * @property targetDomainName Target domain name.
 */
public data class DomainNameDomainNameConfigurationArgs(
    public val certificateArn: Output<String>,
    public val endpointType: Output<String>,
    public val hostedZoneId: Output<String>? = null,
    public val ownershipVerificationCertificateArn: Output<String>? = null,
    public val securityPolicy: Output<String>,
    public val targetDomainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.DomainNameDomainNameConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.DomainNameDomainNameConfigurationArgs =
        com.pulumi.aws.apigatewayv2.inputs.DomainNameDomainNameConfigurationArgs.builder()
            .certificateArn(certificateArn.applyValue({ args0 -> args0 }))
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .hostedZoneId(hostedZoneId?.applyValue({ args0 -> args0 }))
            .ownershipVerificationCertificateArn(
                ownershipVerificationCertificateArn?.applyValue({ args0 ->
                    args0
                }),
            )
            .securityPolicy(securityPolicy.applyValue({ args0 -> args0 }))
            .targetDomainName(targetDomainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainNameDomainNameConfigurationArgs].
 */
@PulumiTagMarker
public class DomainNameDomainNameConfigurationArgsBuilder internal constructor() {
    private var certificateArn: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var hostedZoneId: Output<String>? = null

    private var ownershipVerificationCertificateArn: Output<String>? = null

    private var securityPolicy: Output<String>? = null

    private var targetDomainName: Output<String>? = null

    /**
     * @param value ARN of an AWS-managed certificate that will be used by the endpoint for the domain name. AWS Certificate Manager is the only supported source. Use the `aws.acm.Certificate` resource to configure an ACM certificate.
     */
    @JvmName("otvrxldpdfffjefs")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value Endpoint type. Valid values: `REGIONAL`.
     */
    @JvmName("ttpapoiaxkdritrw")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value Amazon Route 53 Hosted Zone ID of the endpoint.
     */
    @JvmName("xteyohrprdxtkwmu")
    public suspend fun hostedZoneId(`value`: Output<String>) {
        this.hostedZoneId = value
    }

    /**
     * @param value ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
     */
    @JvmName("tcgbdwrivuyfskxe")
    public suspend fun ownershipVerificationCertificateArn(`value`: Output<String>) {
        this.ownershipVerificationCertificateArn = value
    }

    /**
     * @param value Transport Layer Security (TLS) version of the [security policy](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-custom-domain-tls-version.html) for the domain name. Valid values: `TLS_1_2`.
     */
    @JvmName("rrdeqygopjhskmnv")
    public suspend fun securityPolicy(`value`: Output<String>) {
        this.securityPolicy = value
    }

    /**
     * @param value Target domain name.
     */
    @JvmName("ychekqmedytkpuna")
    public suspend fun targetDomainName(`value`: Output<String>) {
        this.targetDomainName = value
    }

    /**
     * @param value ARN of an AWS-managed certificate that will be used by the endpoint for the domain name. AWS Certificate Manager is the only supported source. Use the `aws.acm.Certificate` resource to configure an ACM certificate.
     */
    @JvmName("cekvvhjixqqaavix")
    public suspend fun certificateArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    /**
     * @param value Endpoint type. Valid values: `REGIONAL`.
     */
    @JvmName("rrlatvjvbbptucaq")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value Amazon Route 53 Hosted Zone ID of the endpoint.
     */
    @JvmName("lhsdcdfqqrpnvuep")
    public suspend fun hostedZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostedZoneId = mapped
    }

    /**
     * @param value ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
     */
    @JvmName("cpxpvfyouxpqkgam")
    public suspend fun ownershipVerificationCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownershipVerificationCertificateArn = mapped
    }

    /**
     * @param value Transport Layer Security (TLS) version of the [security policy](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-custom-domain-tls-version.html) for the domain name. Valid values: `TLS_1_2`.
     */
    @JvmName("bapgjcshxlhgoylj")
    public suspend fun securityPolicy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityPolicy = mapped
    }

    /**
     * @param value Target domain name.
     */
    @JvmName("ugwdpncbqtdpclyi")
    public suspend fun targetDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDomainName = mapped
    }

    internal fun build(): DomainNameDomainNameConfigurationArgs =
        DomainNameDomainNameConfigurationArgs(
            certificateArn = certificateArn ?: throw PulumiNullFieldException("certificateArn"),
            endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
            hostedZoneId = hostedZoneId,
            ownershipVerificationCertificateArn = ownershipVerificationCertificateArn,
            securityPolicy = securityPolicy ?: throw PulumiNullFieldException("securityPolicy"),
            targetDomainName = targetDomainName,
        )
}
