@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.GetApiPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApi.
 * @property apiId API identifier.
 * @property tags Map of resource tags.
 */
public data class GetApiPlainArgs(
    public val apiId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.GetApiPlainArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.GetApiPlainArgs =
        com.pulumi.aws.apigatewayv2.inputs.GetApiPlainArgs.builder()
            .apiId(apiId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetApiPlainArgs].
 */
@PulumiTagMarker
public class GetApiPlainArgsBuilder internal constructor() {
    private var apiId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value API identifier.
     */
    @JvmName("sbjahecrttfxtbjx")
    public suspend fun apiId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiId = mapped
    }

    /**
     * @param value Map of resource tags.
     */
    @JvmName("uncjiwgmhimbfjal")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags.
     */
    @JvmName("jyywgodenqehejld")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetApiPlainArgs = GetApiPlainArgs(
        apiId = apiId ?: throw PulumiNullFieldException("apiId"),
        tags = tags,
    )
}
