@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.GetVpcLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcLink.
 * @property tags VPC Link Tags.
 * @property vpcLinkId VPC Link ID
 */
public data class GetVpcLinkPlainArgs(
    public val tags: Map<String, String>? = null,
    public val vpcLinkId: String,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.GetVpcLinkPlainArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.GetVpcLinkPlainArgs =
        com.pulumi.aws.apigatewayv2.inputs.GetVpcLinkPlainArgs.builder()
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcLinkId(vpcLinkId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcLinkPlainArgs].
 */
@PulumiTagMarker
public class GetVpcLinkPlainArgsBuilder internal constructor() {
    private var tags: Map<String, String>? = null

    private var vpcLinkId: String? = null

    /**
     * @param value VPC Link Tags.
     */
    @JvmName("xevhgimqwkfuhbmg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values VPC Link Tags.
     */
    @JvmName("wfxhmjwampnkrprv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value VPC Link ID
     */
    @JvmName("fquvnrolfiuanddw")
    public suspend fun vpcLinkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vpcLinkId = mapped
    }

    internal fun build(): GetVpcLinkPlainArgs = GetVpcLinkPlainArgs(
        tags = tags,
        vpcLinkId = vpcLinkId ?: throw PulumiNullFieldException("vpcLinkId"),
    )
}
