@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.IntegrationTlsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property serverNameToVerify If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
 */
public data class IntegrationTlsConfigArgs(
    public val serverNameToVerify: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.IntegrationTlsConfigArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.IntegrationTlsConfigArgs =
        com.pulumi.aws.apigatewayv2.inputs.IntegrationTlsConfigArgs.builder()
            .serverNameToVerify(serverNameToVerify?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationTlsConfigArgs].
 */
@PulumiTagMarker
public class IntegrationTlsConfigArgsBuilder internal constructor() {
    private var serverNameToVerify: Output<String>? = null

    /**
     * @param value If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
     */
    @JvmName("ldxwmdrsyroplwqy")
    public suspend fun serverNameToVerify(`value`: Output<String>) {
        this.serverNameToVerify = value
    }

    /**
     * @param value If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
     */
    @JvmName("yeymtbybhpbjcwca")
    public suspend fun serverNameToVerify(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverNameToVerify = mapped
    }

    internal fun build(): IntegrationTlsConfigArgs = IntegrationTlsConfigArgs(
        serverNameToVerify = serverNameToVerify,
    )
}
