@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.inputs

import com.pulumi.aws.apigatewayv2.inputs.StageRouteSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataTraceEnabled Whether data trace logging is enabled for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
 * Defaults to `false`. Supported only for WebSocket APIs.
 * @property detailedMetricsEnabled Whether detailed metrics are enabled for the route. Defaults to `false`.
 * @property loggingLevel Logging level for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
 * Valid values: `ERROR`, `INFO`, `OFF`. Defaults to `OFF`. Supported only for WebSocket APIs. This provider will only perform drift detection of its value when present in a configuration.
 * @property routeKey Route key.
 * @property throttlingBurstLimit Throttling burst limit for the route.
 * @property throttlingRateLimit Throttling rate limit for the route.
 */
public data class StageRouteSettingArgs(
    public val dataTraceEnabled: Output<Boolean>? = null,
    public val detailedMetricsEnabled: Output<Boolean>? = null,
    public val loggingLevel: Output<String>? = null,
    public val routeKey: Output<String>,
    public val throttlingBurstLimit: Output<Int>? = null,
    public val throttlingRateLimit: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigatewayv2.inputs.StageRouteSettingArgs> {
    override fun toJava(): com.pulumi.aws.apigatewayv2.inputs.StageRouteSettingArgs =
        com.pulumi.aws.apigatewayv2.inputs.StageRouteSettingArgs.builder()
            .dataTraceEnabled(dataTraceEnabled?.applyValue({ args0 -> args0 }))
            .detailedMetricsEnabled(detailedMetricsEnabled?.applyValue({ args0 -> args0 }))
            .loggingLevel(loggingLevel?.applyValue({ args0 -> args0 }))
            .routeKey(routeKey.applyValue({ args0 -> args0 }))
            .throttlingBurstLimit(throttlingBurstLimit?.applyValue({ args0 -> args0 }))
            .throttlingRateLimit(throttlingRateLimit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StageRouteSettingArgs].
 */
@PulumiTagMarker
public class StageRouteSettingArgsBuilder internal constructor() {
    private var dataTraceEnabled: Output<Boolean>? = null

    private var detailedMetricsEnabled: Output<Boolean>? = null

    private var loggingLevel: Output<String>? = null

    private var routeKey: Output<String>? = null

    private var throttlingBurstLimit: Output<Int>? = null

    private var throttlingRateLimit: Output<Double>? = null

    /**
     * @param value Whether data trace logging is enabled for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
     * Defaults to `false`. Supported only for WebSocket APIs.
     */
    @JvmName("eoffcyxygiuprkva")
    public suspend fun dataTraceEnabled(`value`: Output<Boolean>) {
        this.dataTraceEnabled = value
    }

    /**
     * @param value Whether detailed metrics are enabled for the route. Defaults to `false`.
     */
    @JvmName("foorrlfjticalmtv")
    public suspend fun detailedMetricsEnabled(`value`: Output<Boolean>) {
        this.detailedMetricsEnabled = value
    }

    /**
     * @param value Logging level for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
     * Valid values: `ERROR`, `INFO`, `OFF`. Defaults to `OFF`. Supported only for WebSocket APIs. This provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("npcuxnharylkdovu")
    public suspend fun loggingLevel(`value`: Output<String>) {
        this.loggingLevel = value
    }

    /**
     * @param value Route key.
     */
    @JvmName("qwycjxbctrnhiyew")
    public suspend fun routeKey(`value`: Output<String>) {
        this.routeKey = value
    }

    /**
     * @param value Throttling burst limit for the route.
     */
    @JvmName("wrgdosdpvsemnyaa")
    public suspend fun throttlingBurstLimit(`value`: Output<Int>) {
        this.throttlingBurstLimit = value
    }

    /**
     * @param value Throttling rate limit for the route.
     */
    @JvmName("bujqngtjhfhdygyb")
    public suspend fun throttlingRateLimit(`value`: Output<Double>) {
        this.throttlingRateLimit = value
    }

    /**
     * @param value Whether data trace logging is enabled for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
     * Defaults to `false`. Supported only for WebSocket APIs.
     */
    @JvmName("vcfvogccglcjinht")
    public suspend fun dataTraceEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTraceEnabled = mapped
    }

    /**
     * @param value Whether detailed metrics are enabled for the route. Defaults to `false`.
     */
    @JvmName("ojlauwsropcsexxh")
    public suspend fun detailedMetricsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailedMetricsEnabled = mapped
    }

    /**
     * @param value Logging level for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
     * Valid values: `ERROR`, `INFO`, `OFF`. Defaults to `OFF`. Supported only for WebSocket APIs. This provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("ustetrpqpdvtelji")
    public suspend fun loggingLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingLevel = mapped
    }

    /**
     * @param value Route key.
     */
    @JvmName("qptlcoxhlhcntfjl")
    public suspend fun routeKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeKey = mapped
    }

    /**
     * @param value Throttling burst limit for the route.
     */
    @JvmName("edqhoqrbeheonhnp")
    public suspend fun throttlingBurstLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttlingBurstLimit = mapped
    }

    /**
     * @param value Throttling rate limit for the route.
     */
    @JvmName("fhqkgrpnvrunsjdd")
    public suspend fun throttlingRateLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttlingRateLimit = mapped
    }

    internal fun build(): StageRouteSettingArgs = StageRouteSettingArgs(
        dataTraceEnabled = dataTraceEnabled,
        detailedMetricsEnabled = detailedMetricsEnabled,
        loggingLevel = loggingLevel,
        routeKey = routeKey ?: throw PulumiNullFieldException("routeKey"),
        throttlingBurstLimit = throttlingBurstLimit,
        throttlingRateLimit = throttlingRateLimit,
    )
}
