@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property audiences List of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list.
 * @property issuer Base domain of the identity provider that issues JSON Web Tokens, such as the `endpoint` attribute of the `aws.cognito.UserPool` resource.
 */
public data class AuthorizerJwtConfiguration(
    public val audiences: List<String>? = null,
    public val issuer: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.AuthorizerJwtConfiguration): AuthorizerJwtConfiguration = AuthorizerJwtConfiguration(
            audiences = javaType.audiences().map({ args0 -> args0 }),
            issuer = javaType.issuer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
