@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property truststoreUri Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
 * @property truststoreVersion Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
 */
public data class DomainNameMutualTlsAuthentication(
    public val truststoreUri: String,
    public val truststoreVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.DomainNameMutualTlsAuthentication): DomainNameMutualTlsAuthentication = DomainNameMutualTlsAuthentication(
            truststoreUri = javaType.truststoreUri(),
            truststoreVersion = javaType.truststoreVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
