@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getApi.
 * @property apiEndpoint URI of the API, of the form `https://{api-id}.execute-api.{region}.amazonaws.com` for HTTP APIs and `wss://{api-id}.execute-api.{region}.amazonaws.com` for WebSocket APIs.
 * @property apiId
 * @property apiKeySelectionExpression An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
 * Applicable for WebSocket APIs.
 * @property arn ARN of the API.
 * @property corsConfigurations Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html).
 * Applicable for HTTP APIs.
 * @property description Description of the API.
 * @property disableExecuteApiEndpoint Whether clients can invoke the API by using the default `execute-api` endpoint.
 * @property executionArn ARN prefix to be used in an `aws.lambda.Permission`'s `source_arn` attribute
 * or in an `aws.iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
 * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the API.
 * @property protocolType API protocol.
 * @property routeSelectionExpression The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
 * @property tags Map of resource tags.
 * @property version Version identifier for the API.
 */
public data class GetApiResult(
    public val apiEndpoint: String,
    public val apiId: String,
    public val apiKeySelectionExpression: String,
    public val arn: String,
    public val corsConfigurations: List<GetApiCorsConfiguration>,
    public val description: String,
    public val disableExecuteApiEndpoint: Boolean,
    public val executionArn: String,
    public val id: String,
    public val name: String,
    public val protocolType: String,
    public val routeSelectionExpression: String,
    public val tags: Map<String, String>,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.GetApiResult): GetApiResult =
            GetApiResult(
                apiEndpoint = javaType.apiEndpoint(),
                apiId = javaType.apiId(),
                apiKeySelectionExpression = javaType.apiKeySelectionExpression(),
                arn = javaType.arn(),
                corsConfigurations = javaType.corsConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.apigatewayv2.kotlin.outputs.GetApiCorsConfiguration.Companion.toKotlin(args0)
                    })
                }),
                description = javaType.description(),
                disableExecuteApiEndpoint = javaType.disableExecuteApiEndpoint(),
                executionArn = javaType.executionArn(),
                id = javaType.id(),
                name = javaType.name(),
                protocolType = javaType.protocolType(),
                routeSelectionExpression = javaType.routeSelectionExpression(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                version = javaType.version(),
            )
    }
}
