@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getApis.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Set of API identifiers.
 * @property name
 * @property protocolType
 * @property tags
 */
public data class GetApisResult(
    public val id: String,
    public val ids: List<String>,
    public val name: String? = null,
    public val protocolType: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.GetApisResult): GetApisResult = GetApisResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocolType = javaType.protocolType().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
