@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVpcLink.
 * @property arn ARN of the VPC Link.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name VPC Link Name.
 * @property securityGroupIds List of security groups associated with the VPC Link.
 * @property subnetIds List of subnets attached to the VPC Link.
 * @property tags VPC Link Tags.
 * @property vpcLinkId
 */
public data class GetVpcLinkResult(
    public val arn: String,
    public val id: String,
    public val name: String,
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val tags: Map<String, String>,
    public val vpcLinkId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.GetVpcLinkResult): GetVpcLinkResult = GetVpcLinkResult(
            arn = javaType.arn(),
            id = javaType.id(),
            name = javaType.name(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcLinkId = javaType.vpcLinkId(),
        )
    }
}
