@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property mappings Key-value map. The key of this map identifies the location of the request parameter to change, and how to change it. The corresponding value specifies the new data for the parameter.
 * See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
 * @property statusCode HTTP status code in the range 200-599.
 */
public data class IntegrationResponseParameter(
    public val mappings: Map<String, String>,
    public val statusCode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.IntegrationResponseParameter): IntegrationResponseParameter = IntegrationResponseParameter(
            mappings = javaType.mappings().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            statusCode = javaType.statusCode(),
        )
    }
}
