@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property serverNameToVerify If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
 */
public data class IntegrationTlsConfig(
    public val serverNameToVerify: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.IntegrationTlsConfig): IntegrationTlsConfig = IntegrationTlsConfig(
            serverNameToVerify = javaType.serverNameToVerify().map({ args0 -> args0 }).orElse(null),
        )
    }
}
