@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property requestParameterKey Request parameter key. This is a [request data mapping parameter](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-data-mapping.html#websocket-mapping-request-parameters).
 * @property required Boolean whether or not the parameter is required.
 */
public data class RouteRequestParameter(
    public val requestParameterKey: String,
    public val required: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.RouteRequestParameter): RouteRequestParameter = RouteRequestParameter(
            requestParameterKey = javaType.requestParameterKey(),
            required = javaType.required(),
        )
    }
}
