@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destinationArn ARN of the CloudWatch Logs log group to receive access logs. Any trailing `:*` is trimmed from the ARN.
 * @property format Single line [format](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/set-up-logging&#46;html#apigateway-cloudwatch-log-formats) of the access logs of data&#46; Refer to log settings for [HTTP](https://docs&#46;aws&#46;amazon&#46;com/apigateway/latest/developerguide/http-api-logging-variables&#46;html) or [Websocket](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-logging.html).
 */
public data class StageAccessLogSettings(
    public val destinationArn: String,
    public val format: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.StageAccessLogSettings): StageAccessLogSettings = StageAccessLogSettings(
            destinationArn = javaType.destinationArn(),
            format = javaType.format(),
        )
    }
}
