@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigatewayv2.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataTraceEnabled Whether data trace logging is enabled for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
 * Defaults to `false`. Supported only for WebSocket APIs.
 * @property detailedMetricsEnabled Whether detailed metrics are enabled for the route. Defaults to `false`.
 * @property loggingLevel Logging level for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
 * Valid values: `ERROR`, `INFO`, `OFF`. Defaults to `OFF`. Supported only for WebSocket APIs. This provider will only perform drift detection of its value when present in a configuration.
 * @property routeKey Route key.
 * @property throttlingBurstLimit Throttling burst limit for the route.
 * @property throttlingRateLimit Throttling rate limit for the route.
 */
public data class StageRouteSetting(
    public val dataTraceEnabled: Boolean? = null,
    public val detailedMetricsEnabled: Boolean? = null,
    public val loggingLevel: String? = null,
    public val routeKey: String,
    public val throttlingBurstLimit: Int? = null,
    public val throttlingRateLimit: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apigatewayv2.outputs.StageRouteSetting): StageRouteSetting = StageRouteSetting(
            dataTraceEnabled = javaType.dataTraceEnabled().map({ args0 -> args0 }).orElse(null),
            detailedMetricsEnabled = javaType.detailedMetricsEnabled().map({ args0 -> args0 }).orElse(null),
            loggingLevel = javaType.loggingLevel().map({ args0 -> args0 }).orElse(null),
            routeKey = javaType.routeKey(),
            throttlingBurstLimit = javaType.throttlingBurstLimit().map({ args0 -> args0 }).orElse(null),
            throttlingRateLimit = javaType.throttlingRateLimit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
