@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin

import com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyStepScalingPolicyConfiguration
import com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyTargetTrackingScalingPolicyConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyStepScalingPolicyConfiguration.Companion.toKotlin as policyStepScalingPolicyConfigurationToKotlin
import com.pulumi.aws.appautoscaling.kotlin.outputs.PolicyTargetTrackingScalingPolicyConfiguration.Companion.toKotlin as policyTargetTrackingScalingPolicyConfigurationToKotlin

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.aws.appautoscaling.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Provides an Application AutoScaling Policy resource.
 * ## Example Usage
 * ### DynamoDB Table Autoscaling
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const dynamodbTableReadTarget = new aws.appautoscaling.Target("dynamodb_table_read_target", {
 *     maxCapacity: 100,
 *     minCapacity: 5,
 *     resourceId: "table/tableName",
 *     scalableDimension: "dynamodb:table:ReadCapacityUnits",
 *     serviceNamespace: "dynamodb",
 * });
 * const dynamodbTableReadPolicy = new aws.appautoscaling.Policy("dynamodb_table_read_policy", {
 *     name: pulumi.interpolate`DynamoDBReadCapacityUtilization:${dynamodbTableReadTarget.resourceId}`,
 *     policyType: "TargetTrackingScaling",
 *     resourceId: dynamodbTableReadTarget.resourceId,
 *     scalableDimension: dynamodbTableReadTarget.scalableDimension,
 *     serviceNamespace: dynamodbTableReadTarget.serviceNamespace,
 *     targetTrackingScalingPolicyConfiguration: {
 *         predefinedMetricSpecification: {
 *             predefinedMetricType: "DynamoDBReadCapacityUtilization",
 *         },
 *         targetValue: 70,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * dynamodb_table_read_target = aws.appautoscaling.Target("dynamodb_table_read_target",
 *     max_capacity=100,
 *     min_capacity=5,
 *     resource_id="table/tableName",
 *     scalable_dimension="dynamodb:table:ReadCapacityUnits",
 *     service_namespace="dynamodb")
 * dynamodb_table_read_policy = aws.appautoscaling.Policy("dynamodb_table_read_policy",
 *     name=dynamodb_table_read_target.resource_id.apply(lambda resource_id: f"DynamoDBReadCapacityUtilization:{resource_id}"),
 *     policy_type="TargetTrackingScaling",
 *     resource_id=dynamodb_table_read_target.resource_id,
 *     scalable_dimension=dynamodb_table_read_target.scalable_dimension,
 *     service_namespace=dynamodb_table_read_target.service_namespace,
 *     target_tracking_scaling_policy_configuration={
 *         "predefined_metric_specification": {
 *             "predefined_metric_type": "DynamoDBReadCapacityUtilization",
 *         },
 *         "target_value": 70,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dynamodbTableReadTarget = new Aws.AppAutoScaling.Target("dynamodb_table_read_target", new()
 *     {
 *         MaxCapacity = 100,
 *         MinCapacity = 5,
 *         ResourceId = "table/tableName",
 *         ScalableDimension = "dynamodb:table:ReadCapacityUnits",
 *         ServiceNamespace = "dynamodb",
 *     });
 *     var dynamodbTableReadPolicy = new Aws.AppAutoScaling.Policy("dynamodb_table_read_policy", new()
 *     {
 *         Name = dynamodbTableReadTarget.ResourceId.Apply(resourceId => $"DynamoDBReadCapacityUtilization:{resourceId}"),
 *         PolicyType = "TargetTrackingScaling",
 *         ResourceId = dynamodbTableReadTarget.ResourceId,
 *         ScalableDimension = dynamodbTableReadTarget.ScalableDimension,
 *         ServiceNamespace = dynamodbTableReadTarget.ServiceNamespace,
 *         TargetTrackingScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs
 *         {
 *             PredefinedMetricSpecification = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs
 *             {
 *                 PredefinedMetricType = "DynamoDBReadCapacityUtilization",
 *             },
 *             TargetValue = 70,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		dynamodbTableReadTarget, err := appautoscaling.NewTarget(ctx, "dynamodb_table_read_target", &appautoscaling.TargetArgs{
 * 			MaxCapacity:       pulumi.Int(100),
 * 			MinCapacity:       pulumi.Int(5),
 * 			ResourceId:        pulumi.String("table/tableName"),
 * 			ScalableDimension: pulumi.String("dynamodb:table:ReadCapacityUnits"),
 * 			ServiceNamespace:  pulumi.String("dynamodb"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appautoscaling.NewPolicy(ctx, "dynamodb_table_read_policy", &appautoscaling.PolicyArgs{
 * 			Name: dynamodbTableReadTarget.ResourceId.ApplyT(func(resourceId string) (string, error) {
 * 				return fmt.Sprintf("DynamoDBReadCapacityUtilization:%v", resourceId), nil
 * 			}).(pulumi.StringOutput),
 * 			PolicyType:        pulumi.String("TargetTrackingScaling"),
 * 			ResourceId:        dynamodbTableReadTarget.ResourceId,
 * 			ScalableDimension: dynamodbTableReadTarget.ScalableDimension,
 * 			ServiceNamespace:  dynamodbTableReadTarget.ServiceNamespace,
 * 			TargetTrackingScalingPolicyConfiguration: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationArgs{
 * 				PredefinedMetricSpecification: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs{
 * 					PredefinedMetricType: pulumi.String("DynamoDBReadCapacityUtilization"),
 * 				},
 * 				TargetValue: pulumi.Float64(70),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dynamodbTableReadTarget = new Target("dynamodbTableReadTarget", TargetArgs.builder()
 *             .maxCapacity(100)
 *             .minCapacity(5)
 *             .resourceId("table/tableName")
 *             .scalableDimension("dynamodb:table:ReadCapacityUnits")
 *             .serviceNamespace("dynamodb")
 *             .build());
 *         var dynamodbTableReadPolicy = new Policy("dynamodbTableReadPolicy", PolicyArgs.builder()
 *             .name(dynamodbTableReadTarget.resourceId().applyValue(resourceId -> String.format("DynamoDBReadCapacityUtilization:%s", resourceId)))
 *             .policyType("TargetTrackingScaling")
 *             .resourceId(dynamodbTableReadTarget.resourceId())
 *             .scalableDimension(dynamodbTableReadTarget.scalableDimension())
 *             .serviceNamespace(dynamodbTableReadTarget.serviceNamespace())
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .predefinedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs.builder()
 *                     .predefinedMetricType("DynamoDBReadCapacityUtilization")
 *                     .build())
 *                 .targetValue(70)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   dynamodbTableReadTarget:
 *     type: aws:appautoscaling:Target
 *     name: dynamodb_table_read_target
 *     properties:
 *       maxCapacity: 100
 *       minCapacity: 5
 *       resourceId: table/tableName
 *       scalableDimension: dynamodb:table:ReadCapacityUnits
 *       serviceNamespace: dynamodb
 *   dynamodbTableReadPolicy:
 *     type: aws:appautoscaling:Policy
 *     name: dynamodb_table_read_policy
 *     properties:
 *       name: DynamoDBReadCapacityUtilization:${dynamodbTableReadTarget.resourceId}
 *       policyType: TargetTrackingScaling
 *       resourceId: ${dynamodbTableReadTarget.resourceId}
 *       scalableDimension: ${dynamodbTableReadTarget.scalableDimension}
 *       serviceNamespace: ${dynamodbTableReadTarget.serviceNamespace}
 *       targetTrackingScalingPolicyConfiguration:
 *         predefinedMetricSpecification:
 *           predefinedMetricType: DynamoDBReadCapacityUtilization
 *         targetValue: 70
 * ```
 * <!--End PulumiCodeChooser -->
 * ### ECS Service Autoscaling
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ecsTarget = new aws.appautoscaling.Target("ecs_target", {
 *     maxCapacity: 4,
 *     minCapacity: 1,
 *     resourceId: "service/clusterName/serviceName",
 *     scalableDimension: "ecs:service:DesiredCount",
 *     serviceNamespace: "ecs",
 * });
 * const ecsPolicy = new aws.appautoscaling.Policy("ecs_policy", {
 *     name: "scale-down",
 *     policyType: "StepScaling",
 *     resourceId: ecsTarget.resourceId,
 *     scalableDimension: ecsTarget.scalableDimension,
 *     serviceNamespace: ecsTarget.serviceNamespace,
 *     stepScalingPolicyConfiguration: {
 *         adjustmentType: "ChangeInCapacity",
 *         cooldown: 60,
 *         metricAggregationType: "Maximum",
 *         stepAdjustments: [{
 *             metricIntervalUpperBound: "0",
 *             scalingAdjustment: -1,
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ecs_target = aws.appautoscaling.Target("ecs_target",
 *     max_capacity=4,
 *     min_capacity=1,
 *     resource_id="service/clusterName/serviceName",
 *     scalable_dimension="ecs:service:DesiredCount",
 *     service_namespace="ecs")
 * ecs_policy = aws.appautoscaling.Policy("ecs_policy",
 *     name="scale-down",
 *     policy_type="StepScaling",
 *     resource_id=ecs_target.resource_id,
 *     scalable_dimension=ecs_target.scalable_dimension,
 *     service_namespace=ecs_target.service_namespace,
 *     step_scaling_policy_configuration={
 *         "adjustment_type": "ChangeInCapacity",
 *         "cooldown": 60,
 *         "metric_aggregation_type": "Maximum",
 *         "step_adjustments": [{
 *             "metric_interval_upper_bound": "0",
 *             "scaling_adjustment": -1,
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ecsTarget = new Aws.AppAutoScaling.Target("ecs_target", new()
 *     {
 *         MaxCapacity = 4,
 *         MinCapacity = 1,
 *         ResourceId = "service/clusterName/serviceName",
 *         ScalableDimension = "ecs:service:DesiredCount",
 *         ServiceNamespace = "ecs",
 *     });
 *     var ecsPolicy = new Aws.AppAutoScaling.Policy("ecs_policy", new()
 *     {
 *         Name = "scale-down",
 *         PolicyType = "StepScaling",
 *         ResourceId = ecsTarget.ResourceId,
 *         ScalableDimension = ecsTarget.ScalableDimension,
 *         ServiceNamespace = ecsTarget.ServiceNamespace,
 *         StepScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationArgs
 *         {
 *             AdjustmentType = "ChangeInCapacity",
 *             Cooldown = 60,
 *             MetricAggregationType = "Maximum",
 *             StepAdjustments = new[]
 *             {
 *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
 *                 {
 *                     MetricIntervalUpperBound = "0",
 *                     ScalingAdjustment = -1,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		ecsTarget, err := appautoscaling.NewTarget(ctx, "ecs_target", &appautoscaling.TargetArgs{
 * 			MaxCapacity:       pulumi.Int(4),
 * 			MinCapacity:       pulumi.Int(1),
 * 			ResourceId:        pulumi.String("service/clusterName/serviceName"),
 * 			ScalableDimension: pulumi.String("ecs:service:DesiredCount"),
 * 			ServiceNamespace:  pulumi.String("ecs"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appautoscaling.NewPolicy(ctx, "ecs_policy", &appautoscaling.PolicyArgs{
 * 			Name:              pulumi.String("scale-down"),
 * 			PolicyType:        pulumi.String("StepScaling"),
 * 			ResourceId:        ecsTarget.ResourceId,
 * 			ScalableDimension: ecsTarget.ScalableDimension,
 * 			ServiceNamespace:  ecsTarget.ServiceNamespace,
 * 			StepScalingPolicyConfiguration: &appautoscaling.PolicyStepScalingPolicyConfigurationArgs{
 * 				AdjustmentType:        pulumi.String("ChangeInCapacity"),
 * 				Cooldown:              pulumi.Int(60),
 * 				MetricAggregationType: pulumi.String("Maximum"),
 * 				StepAdjustments: appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArray{
 * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
 * 						MetricIntervalUpperBound: pulumi.String("0"),
 * 						ScalingAdjustment:        int(-1),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   ecsTarget:
 *     type: aws:appautoscaling:Target
 *     name: ecs_target
 *     properties:
 *       maxCapacity: 4
 *       minCapacity: 1
 *       resourceId: service/clusterName/serviceName
 *       scalableDimension: ecs:service:DesiredCount
 *       serviceNamespace: ecs
 *   ecsPolicy:
 *     type: aws:appautoscaling:Policy
 *     name: ecs_policy
 *     properties:
 *       name: scale-down
 *       policyType: StepScaling
 *       resourceId: ${ecsTarget.resourceId}
 *       scalableDimension: ${ecsTarget.scalableDimension}
 *       serviceNamespace: ${ecsTarget.serviceNamespace}
 *       stepScalingPolicyConfiguration:
 *         adjustmentType: ChangeInCapacity
 *         cooldown: 60
 *         metricAggregationType: Maximum
 *         stepAdjustments:
 *           - metricIntervalUpperBound: 0
 *             scalingAdjustment: -1
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Preserve desired count when updating an autoscaled ECS Service
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ecsService = new aws.ecs.Service("ecs_service", {
 *     name: "serviceName",
 *     cluster: "clusterName",
 *     taskDefinition: "taskDefinitionFamily:1",
 *     desiredCount: 2,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ecs_service = aws.ecs.Service("ecs_service",
 *     name="serviceName",
 *     cluster="clusterName",
 *     task_definition="taskDefinitionFamily:1",
 *     desired_count=2)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ecsService = new Aws.Ecs.Service("ecs_service", new()
 *     {
 *         Name = "serviceName",
 *         Cluster = "clusterName",
 *         TaskDefinition = "taskDefinitionFamily:1",
 *         DesiredCount = 2,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ecs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ecs.NewService(ctx, "ecs_service", &ecs.ServiceArgs{
 * 			Name:           pulumi.String("serviceName"),
 * 			Cluster:        pulumi.String("clusterName"),
 * 			TaskDefinition: pulumi.String("taskDefinitionFamily:1"),
 * 			DesiredCount:   pulumi.Int(2),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecs.Service;
 * import com.pulumi.aws.ecs.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ecsService = new Service("ecsService", ServiceArgs.builder()
 *             .name("serviceName")
 *             .cluster("clusterName")
 *             .taskDefinition("taskDefinitionFamily:1")
 *             .desiredCount(2)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ecsService:
 *     type: aws:ecs:Service
 *     name: ecs_service
 *     properties:
 *       name: serviceName
 *       cluster: clusterName
 *       taskDefinition: taskDefinitionFamily:1
 *       desiredCount: 2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Aurora Read Replica Autoscaling
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const replicas = new aws.appautoscaling.Target("replicas", {
 *     serviceNamespace: "rds",
 *     scalableDimension: "rds:cluster:ReadReplicaCount",
 *     resourceId: `cluster:${example.id}`,
 *     minCapacity: 1,
 *     maxCapacity: 15,
 * });
 * const replicasPolicy = new aws.appautoscaling.Policy("replicas", {
 *     name: "cpu-auto-scaling",
 *     serviceNamespace: replicas.serviceNamespace,
 *     scalableDimension: replicas.scalableDimension,
 *     resourceId: replicas.resourceId,
 *     policyType: "TargetTrackingScaling",
 *     targetTrackingScalingPolicyConfiguration: {
 *         predefinedMetricSpecification: {
 *             predefinedMetricType: "RDSReaderAverageCPUUtilization",
 *         },
 *         targetValue: 75,
 *         scaleInCooldown: 300,
 *         scaleOutCooldown: 300,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * replicas = aws.appautoscaling.Target("replicas",
 *     service_namespace="rds",
 *     scalable_dimension="rds:cluster:ReadReplicaCount",
 *     resource_id=f"cluster:{example['id']}",
 *     min_capacity=1,
 *     max_capacity=15)
 * replicas_policy = aws.appautoscaling.Policy("replicas",
 *     name="cpu-auto-scaling",
 *     service_namespace=replicas.service_namespace,
 *     scalable_dimension=replicas.scalable_dimension,
 *     resource_id=replicas.resource_id,
 *     policy_type="TargetTrackingScaling",
 *     target_tracking_scaling_policy_configuration={
 *         "predefined_metric_specification": {
 *             "predefined_metric_type": "RDSReaderAverageCPUUtilization",
 *         },
 *         "target_value": 75,
 *         "scale_in_cooldown": 300,
 *         "scale_out_cooldown": 300,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicas = new Aws.AppAutoScaling.Target("replicas", new()
 *     {
 *         ServiceNamespace = "rds",
 *         ScalableDimension = "rds:cluster:ReadReplicaCount",
 *         ResourceId = $"cluster:{example.Id}",
 *         MinCapacity = 1,
 *         MaxCapacity = 15,
 *     });
 *     var replicasPolicy = new Aws.AppAutoScaling.Policy("replicas", new()
 *     {
 *         Name = "cpu-auto-scaling",
 *         ServiceNamespace = replicas.ServiceNamespace,
 *         ScalableDimension = replicas.ScalableDimension,
 *         ResourceId = replicas.ResourceId,
 *         PolicyType = "TargetTrackingScaling",
 *         TargetTrackingScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs
 *         {
 *             PredefinedMetricSpecification = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs
 *             {
 *                 PredefinedMetricType = "RDSReaderAverageCPUUtilization",
 *             },
 *             TargetValue = 75,
 *             ScaleInCooldown = 300,
 *             ScaleOutCooldown = 300,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		replicas, err := appautoscaling.NewTarget(ctx, "replicas", &appautoscaling.TargetArgs{
 * 			ServiceNamespace:  pulumi.String("rds"),
 * 			ScalableDimension: pulumi.String("rds:cluster:ReadReplicaCount"),
 * 			ResourceId:        pulumi.Sprintf("cluster:%v", example.Id),
 * 			MinCapacity:       pulumi.Int(1),
 * 			MaxCapacity:       pulumi.Int(15),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appautoscaling.NewPolicy(ctx, "replicas", &appautoscaling.PolicyArgs{
 * 			Name:              pulumi.String("cpu-auto-scaling"),
 * 			ServiceNamespace:  replicas.ServiceNamespace,
 * 			ScalableDimension: replicas.ScalableDimension,
 * 			ResourceId:        replicas.ResourceId,
 * 			PolicyType:        pulumi.String("TargetTrackingScaling"),
 * 			TargetTrackingScalingPolicyConfiguration: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationArgs{
 * 				PredefinedMetricSpecification: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs{
 * 					PredefinedMetricType: pulumi.String("RDSReaderAverageCPUUtilization"),
 * 				},
 * 				TargetValue:      pulumi.Float64(75),
 * 				ScaleInCooldown:  pulumi.Int(300),
 * 				ScaleOutCooldown: pulumi.Int(300),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicas = new Target("replicas", TargetArgs.builder()
 *             .serviceNamespace("rds")
 *             .scalableDimension("rds:cluster:ReadReplicaCount")
 *             .resourceId(String.format("cluster:%s", example.id()))
 *             .minCapacity(1)
 *             .maxCapacity(15)
 *             .build());
 *         var replicasPolicy = new Policy("replicasPolicy", PolicyArgs.builder()
 *             .name("cpu-auto-scaling")
 *             .serviceNamespace(replicas.serviceNamespace())
 *             .scalableDimension(replicas.scalableDimension())
 *             .resourceId(replicas.resourceId())
 *             .policyType("TargetTrackingScaling")
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .predefinedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs.builder()
 *                     .predefinedMetricType("RDSReaderAverageCPUUtilization")
 *                     .build())
 *                 .targetValue(75)
 *                 .scaleInCooldown(300)
 *                 .scaleOutCooldown(300)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   replicas:
 *     type: aws:appautoscaling:Target
 *     properties:
 *       serviceNamespace: rds
 *       scalableDimension: rds:cluster:ReadReplicaCount
 *       resourceId: cluster:${example.id}
 *       minCapacity: 1
 *       maxCapacity: 15
 *   replicasPolicy:
 *     type: aws:appautoscaling:Policy
 *     name: replicas
 *     properties:
 *       name: cpu-auto-scaling
 *       serviceNamespace: ${replicas.serviceNamespace}
 *       scalableDimension: ${replicas.scalableDimension}
 *       resourceId: ${replicas.resourceId}
 *       policyType: TargetTrackingScaling
 *       targetTrackingScalingPolicyConfiguration:
 *         predefinedMetricSpecification:
 *           predefinedMetricType: RDSReaderAverageCPUUtilization
 *         targetValue: 75
 *         scaleInCooldown: 300
 *         scaleOutCooldown: 300
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create target tracking scaling policy using metric math
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ecsTarget = new aws.appautoscaling.Target("ecs_target", {
 *     maxCapacity: 4,
 *     minCapacity: 1,
 *     resourceId: "service/clusterName/serviceName",
 *     scalableDimension: "ecs:service:DesiredCount",
 *     serviceNamespace: "ecs",
 * });
 * const example = new aws.appautoscaling.Policy("example", {
 *     name: "foo",
 *     policyType: "TargetTrackingScaling",
 *     resourceId: ecsTarget.resourceId,
 *     scalableDimension: ecsTarget.scalableDimension,
 *     serviceNamespace: ecsTarget.serviceNamespace,
 *     targetTrackingScalingPolicyConfiguration: {
 *         targetValue: 100,
 *         customizedMetricSpecification: {
 *             metrics: [
 *                 {
 *                     label: "Get the queue size (the number of messages waiting to be processed)",
 *                     id: "m1",
 *                     metricStat: {
 *                         metric: {
 *                             metricName: "ApproximateNumberOfMessagesVisible",
 *                             namespace: "AWS/SQS",
 *                             dimensions: [{
 *                                 name: "QueueName",
 *                                 value: "my-queue",
 *                             }],
 *                         },
 *                         stat: "Sum",
 *                     },
 *                     returnData: false,
 *                 },
 *                 {
 *                     label: "Get the ECS running task count (the number of currently running tasks)",
 *                     id: "m2",
 *                     metricStat: {
 *                         metric: {
 *                             metricName: "RunningTaskCount",
 *                             namespace: "ECS/ContainerInsights",
 *                             dimensions: [
 *                                 {
 *                                     name: "ClusterName",
 *                                     value: "default",
 *                                 },
 *                                 {
 *                                     name: "ServiceName",
 *                                     value: "web-app",
 *                                 },
 *                             ],
 *                         },
 *                         stat: "Average",
 *                     },
 *                     returnData: false,
 *                 },
 *                 {
 *                     label: "Calculate the backlog per instance",
 *                     id: "e1",
 *                     expression: "m1 / m2",
 *                     returnData: true,
 *                 },
 *             ],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ecs_target = aws.appautoscaling.Target("ecs_target",
 *     max_capacity=4,
 *     min_capacity=1,
 *     resource_id="service/clusterName/serviceName",
 *     scalable_dimension="ecs:service:DesiredCount",
 *     service_namespace="ecs")
 * example = aws.appautoscaling.Policy("example",
 *     name="foo",
 *     policy_type="TargetTrackingScaling",
 *     resource_id=ecs_target.resource_id,
 *     scalable_dimension=ecs_target.scalable_dimension,
 *     service_namespace=ecs_target.service_namespace,
 *     target_tracking_scaling_policy_configuration={
 *         "target_value": 100,
 *         "customized_metric_specification": {
 *             "metrics": [
 *                 {
 *                     "label": "Get the queue size (the number of messages waiting to be processed)",
 *                     "id": "m1",
 *                     "metric_stat": {
 *                         "metric": {
 *                             "metric_name": "ApproximateNumberOfMessagesVisible",
 *                             "namespace": "AWS/SQS",
 *                             "dimensions": [{
 *                                 "name": "QueueName",
 *                                 "value": "my-queue",
 *                             }],
 *                         },
 *                         "stat": "Sum",
 *                     },
 *                     "return_data": False,
 *                 },
 *                 {
 *                     "label": "Get the ECS running task count (the number of currently running tasks)",
 *                     "id": "m2",
 *                     "metric_stat": {
 *                         "metric": {
 *                             "metric_name": "RunningTaskCount",
 *                             "namespace": "ECS/ContainerInsights",
 *                             "dimensions": [
 *                                 {
 *                                     "name": "ClusterName",
 *                                     "value": "default",
 *                                 },
 *                                 {
 *                                     "name": "ServiceName",
 *                                     "value": "web-app",
 *                                 },
 *                             ],
 *                         },
 *                         "stat": "Average",
 *                     },
 *                     "return_data": False,
 *                 },
 *                 {
 *                     "label": "Calculate the backlog per instance",
 *                     "id": "e1",
 *                     "expression": "m1 / m2",
 *                     "return_data": True,
 *                 },
 *             ],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ecsTarget = new Aws.AppAutoScaling.Target("ecs_target", new()
 *     {
 *         MaxCapacity = 4,
 *         MinCapacity = 1,
 *         ResourceId = "service/clusterName/serviceName",
 *         ScalableDimension = "ecs:service:DesiredCount",
 *         ServiceNamespace = "ecs",
 *     });
 *     var example = new Aws.AppAutoScaling.Policy("example", new()
 *     {
 *         Name = "foo",
 *         PolicyType = "TargetTrackingScaling",
 *         ResourceId = ecsTarget.ResourceId,
 *         ScalableDimension = ecsTarget.ScalableDimension,
 *         ServiceNamespace = ecsTarget.ServiceNamespace,
 *         TargetTrackingScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs
 *         {
 *             TargetValue = 100,
 *             CustomizedMetricSpecification = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs
 *             {
 *                 Metrics = new[]
 *                 {
 *                     new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs
 *                     {
 *                         Label = "Get the queue size (the number of messages waiting to be processed)",
 *                         Id = "m1",
 *                         MetricStat = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatArgs
 *                         {
 *                             Metric = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs
 *                             {
 *                                 MetricName = "ApproximateNumberOfMessagesVisible",
 *                                 Namespace = "AWS/SQS",
 *                                 Dimensions = new[]
 *                                 {
 *                                     new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs
 *                                     {
 *                                         Name = "QueueName",
 *                                         Value = "my-queue",
 *                                     },
 *                                 },
 *                             },
 *                             Stat = "Sum",
 *                         },
 *                         ReturnData = false,
 *                     },
 *                     new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs
 *                     {
 *                         Label = "Get the ECS running task count (the number of currently running tasks)",
 *                         Id = "m2",
 *                         MetricStat = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatArgs
 *                         {
 *                             Metric = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs
 *                             {
 *                                 MetricName = "RunningTaskCount",
 *                                 Namespace = "ECS/ContainerInsights",
 *                                 Dimensions = new[]
 *                                 {
 *                                     new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs
 *                                     {
 *                                         Name = "ClusterName",
 *                                         Value = "default",
 *                                     },
 *                                     new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs
 *                                     {
 *                                         Name = "ServiceName",
 *                                         Value = "web-app",
 *                                     },
 *                                 },
 *                             },
 *                             Stat = "Average",
 *                         },
 *                         ReturnData = false,
 *                     },
 *                     new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs
 *                     {
 *                         Label = "Calculate the backlog per instance",
 *                         Id = "e1",
 *                         Expression = "m1 / m2",
 *                         ReturnData = true,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		ecsTarget, err := appautoscaling.NewTarget(ctx, "ecs_target", &appautoscaling.TargetArgs{
 * 			MaxCapacity:       pulumi.Int(4),
 * 			MinCapacity:       pulumi.Int(1),
 * 			ResourceId:        pulumi.String("service/clusterName/serviceName"),
 * 			ScalableDimension: pulumi.String("ecs:service:DesiredCount"),
 * 			ServiceNamespace:  pulumi.String("ecs"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appautoscaling.NewPolicy(ctx, "example", &appautoscaling.PolicyArgs{
 * 			Name:              pulumi.String("foo"),
 * 			PolicyType:        pulumi.String("TargetTrackingScaling"),
 * 			ResourceId:        ecsTarget.ResourceId,
 * 			ScalableDimension: ecsTarget.ScalableDimension,
 * 			ServiceNamespace:  ecsTarget.ServiceNamespace,
 * 			TargetTrackingScalingPolicyConfiguration: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationArgs{
 * 				TargetValue: pulumi.Float64(100),
 * 				CustomizedMetricSpecification: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs{
 * 					Metrics: appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArray{
 * 						&appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs{
 * 							Label: pulumi.String("Get the queue size (the number of messages waiting to be processed)"),
 * 							Id:    pulumi.String("m1"),
 * 							MetricStat: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatArgs{
 * 								Metric: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs{
 * 									MetricName: pulumi.String("ApproximateNumberOfMessagesVisible"),
 * 									Namespace:  pulumi.String("AWS/SQS"),
 * 									Dimensions: appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArray{
 * 										&appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs{
 * 											Name:  pulumi.String("QueueName"),
 * 											Value: pulumi.String("my-queue"),
 * 										},
 * 									},
 * 								},
 * 								Stat: pulumi.String("Sum"),
 * 							},
 * 							ReturnData: pulumi.Bool(false),
 * 						},
 * 						&appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs{
 * 							Label: pulumi.String("Get the ECS running task count (the number of currently running tasks)"),
 * 							Id:    pulumi.String("m2"),
 * 							MetricStat: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatArgs{
 * 								Metric: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs{
 * 									MetricName: pulumi.String("RunningTaskCount"),
 * 									Namespace:  pulumi.String("ECS/ContainerInsights"),
 * 									Dimensions: appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArray{
 * 										&appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs{
 * 											Name:  pulumi.String("ClusterName"),
 * 											Value: pulumi.String("default"),
 * 										},
 * 										&appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs{
 * 											Name:  pulumi.String("ServiceName"),
 * 											Value: pulumi.String("web-app"),
 * 										},
 * 									},
 * 								},
 * 								Stat: pulumi.String("Average"),
 * 							},
 * 							ReturnData: pulumi.Bool(false),
 * 						},
 * 						&appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs{
 * 							Label:      pulumi.String("Calculate the backlog per instance"),
 * 							Id:         pulumi.String("e1"),
 * 							Expression: pulumi.String("m1 / m2"),
 * 							ReturnData: pulumi.Bool(true),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ecsTarget = new Target("ecsTarget", TargetArgs.builder()
 *             .maxCapacity(4)
 *             .minCapacity(1)
 *             .resourceId("service/clusterName/serviceName")
 *             .scalableDimension("ecs:service:DesiredCount")
 *             .serviceNamespace("ecs")
 *             .build());
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .name("foo")
 *             .policyType("TargetTrackingScaling")
 *             .resourceId(ecsTarget.resourceId())
 *             .scalableDimension(ecsTarget.scalableDimension())
 *             .serviceNamespace(ecsTarget.serviceNamespace())
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .targetValue(100)
 *                 .customizedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs.builder()
 *                     .metrics(
 *                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .label("Get the queue size (the number of messages waiting to be processed)")
 *                             .id("m1")
 *                             .metricStat(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatArgs.builder()
 *                                 .metric(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder()
 *                                     .metricName("ApproximateNumberOfMessagesVisible")
 *                                     .namespace("AWS/SQS")
 *                                     .dimensions(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs.builder()
 *                                         .name("QueueName")
 *                                         .value("my-queue")
 *                                         .build())
 *                                     .build())
 *                                 .stat("Sum")
 *                                 .build())
 *                             .returnData(false)
 *                             .build(),
 *                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .label("Get the ECS running task count (the number of currently running tasks)")
 *                             .id("m2")
 *                             .metricStat(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatArgs.builder()
 *                                 .metric(PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder()
 *                                     .metricName("RunningTaskCount")
 *                                     .namespace("ECS/ContainerInsights")
 *                                     .dimensions(
 *                                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs.builder()
 *                                             .name("ClusterName")
 *                                             .value("default")
 *                                             .build(),
 *                                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs.builder()
 *                                             .name("ServiceName")
 *                                             .value("web-app")
 *                                             .build())
 *                                     .build())
 *                                 .stat("Average")
 *                                 .build())
 *                             .returnData(false)
 *                             .build(),
 *                         PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs.builder()
 *                             .label("Calculate the backlog per instance")
 *                             .id("e1")
 *                             .expression("m1 / m2")
 *                             .returnData(true)
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ecsTarget:
 *     type: aws:appautoscaling:Target
 *     name: ecs_target
 *     properties:
 *       maxCapacity: 4
 *       minCapacity: 1
 *       resourceId: service/clusterName/serviceName
 *       scalableDimension: ecs:service:DesiredCount
 *       serviceNamespace: ecs
 *   example:
 *     type: aws:appautoscaling:Policy
 *     properties:
 *       name: foo
 *       policyType: TargetTrackingScaling
 *       resourceId: ${ecsTarget.resourceId}
 *       scalableDimension: ${ecsTarget.scalableDimension}
 *       serviceNamespace: ${ecsTarget.serviceNamespace}
 *       targetTrackingScalingPolicyConfiguration:
 *         targetValue: 100
 *         customizedMetricSpecification:
 *           metrics:
 *             - label: Get the queue size (the number of messages waiting to be processed)
 *               id: m1
 *               metricStat:
 *                 metric:
 *                   metricName: ApproximateNumberOfMessagesVisible
 *                   namespace: AWS/SQS
 *                   dimensions:
 *                     - name: QueueName
 *                       value: my-queue
 *                 stat: Sum
 *               returnData: false
 *             - label: Get the ECS running task count (the number of currently running tasks)
 *               id: m2
 *               metricStat:
 *                 metric:
 *                   metricName: RunningTaskCount
 *                   namespace: ECS/ContainerInsights
 *                   dimensions:
 *                     - name: ClusterName
 *                       value: default
 *                     - name: ServiceName
 *                       value: web-app
 *                 stat: Average
 *               returnData: false
 *             - label: Calculate the backlog per instance
 *               id: e1
 *               expression: m1 / m2
 *               returnData: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### MSK / Kafka Autoscaling
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const mskTarget = new aws.appautoscaling.Target("msk_target", {
 *     serviceNamespace: "kafka",
 *     scalableDimension: "kafka:broker-storage:VolumeSize",
 *     resourceId: example.arn,
 *     minCapacity: 1,
 *     maxCapacity: 8,
 * });
 * const targets = new aws.appautoscaling.Policy("targets", {
 *     name: "storage-size-auto-scaling",
 *     serviceNamespace: mskTarget.serviceNamespace,
 *     scalableDimension: mskTarget.scalableDimension,
 *     resourceId: mskTarget.resourceId,
 *     policyType: "TargetTrackingScaling",
 *     targetTrackingScalingPolicyConfiguration: {
 *         predefinedMetricSpecification: {
 *             predefinedMetricType: "KafkaBrokerStorageUtilization",
 *         },
 *         targetValue: 55,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * msk_target = aws.appautoscaling.Target("msk_target",
 *     service_namespace="kafka",
 *     scalable_dimension="kafka:broker-storage:VolumeSize",
 *     resource_id=example["arn"],
 *     min_capacity=1,
 *     max_capacity=8)
 * targets = aws.appautoscaling.Policy("targets",
 *     name="storage-size-auto-scaling",
 *     service_namespace=msk_target.service_namespace,
 *     scalable_dimension=msk_target.scalable_dimension,
 *     resource_id=msk_target.resource_id,
 *     policy_type="TargetTrackingScaling",
 *     target_tracking_scaling_policy_configuration={
 *         "predefined_metric_specification": {
 *             "predefined_metric_type": "KafkaBrokerStorageUtilization",
 *         },
 *         "target_value": 55,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mskTarget = new Aws.AppAutoScaling.Target("msk_target", new()
 *     {
 *         ServiceNamespace = "kafka",
 *         ScalableDimension = "kafka:broker-storage:VolumeSize",
 *         ResourceId = example.Arn,
 *         MinCapacity = 1,
 *         MaxCapacity = 8,
 *     });
 *     var targets = new Aws.AppAutoScaling.Policy("targets", new()
 *     {
 *         Name = "storage-size-auto-scaling",
 *         ServiceNamespace = mskTarget.ServiceNamespace,
 *         ScalableDimension = mskTarget.ScalableDimension,
 *         ResourceId = mskTarget.ResourceId,
 *         PolicyType = "TargetTrackingScaling",
 *         TargetTrackingScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs
 *         {
 *             PredefinedMetricSpecification = new Aws.AppAutoScaling.Inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs
 *             {
 *                 PredefinedMetricType = "KafkaBrokerStorageUtilization",
 *             },
 *             TargetValue = 55,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		mskTarget, err := appautoscaling.NewTarget(ctx, "msk_target", &appautoscaling.TargetArgs{
 * 			ServiceNamespace:  pulumi.String("kafka"),
 * 			ScalableDimension: pulumi.String("kafka:broker-storage:VolumeSize"),
 * 			ResourceId:        pulumi.Any(example.Arn),
 * 			MinCapacity:       pulumi.Int(1),
 * 			MaxCapacity:       pulumi.Int(8),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appautoscaling.NewPolicy(ctx, "targets", &appautoscaling.PolicyArgs{
 * 			Name:              pulumi.String("storage-size-auto-scaling"),
 * 			ServiceNamespace:  mskTarget.ServiceNamespace,
 * 			ScalableDimension: mskTarget.ScalableDimension,
 * 			ResourceId:        mskTarget.ResourceId,
 * 			PolicyType:        pulumi.String("TargetTrackingScaling"),
 * 			TargetTrackingScalingPolicyConfiguration: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationArgs{
 * 				PredefinedMetricSpecification: &appautoscaling.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs{
 * 					PredefinedMetricType: pulumi.String("KafkaBrokerStorageUtilization"),
 * 				},
 * 				TargetValue: pulumi.Float64(55),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appautoscaling.Target;
 * import com.pulumi.aws.appautoscaling.TargetArgs;
 * import com.pulumi.aws.appautoscaling.Policy;
 * import com.pulumi.aws.appautoscaling.PolicyArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationArgs;
 * import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mskTarget = new Target("mskTarget", TargetArgs.builder()
 *             .serviceNamespace("kafka")
 *             .scalableDimension("kafka:broker-storage:VolumeSize")
 *             .resourceId(example.arn())
 *             .minCapacity(1)
 *             .maxCapacity(8)
 *             .build());
 *         var targets = new Policy("targets", PolicyArgs.builder()
 *             .name("storage-size-auto-scaling")
 *             .serviceNamespace(mskTarget.serviceNamespace())
 *             .scalableDimension(mskTarget.scalableDimension())
 *             .resourceId(mskTarget.resourceId())
 *             .policyType("TargetTrackingScaling")
 *             .targetTrackingScalingPolicyConfiguration(PolicyTargetTrackingScalingPolicyConfigurationArgs.builder()
 *                 .predefinedMetricSpecification(PolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecificationArgs.builder()
 *                     .predefinedMetricType("KafkaBrokerStorageUtilization")
 *                     .build())
 *                 .targetValue(55)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   mskTarget:
 *     type: aws:appautoscaling:Target
 *     name: msk_target
 *     properties:
 *       serviceNamespace: kafka
 *       scalableDimension: kafka:broker-storage:VolumeSize
 *       resourceId: ${example.arn}
 *       minCapacity: 1
 *       maxCapacity: 8
 *   targets:
 *     type: aws:appautoscaling:Policy
 *     properties:
 *       name: storage-size-auto-scaling
 *       serviceNamespace: ${mskTarget.serviceNamespace}
 *       scalableDimension: ${mskTarget.scalableDimension}
 *       resourceId: ${mskTarget.resourceId}
 *       policyType: TargetTrackingScaling
 *       targetTrackingScalingPolicyConfiguration:
 *         predefinedMetricSpecification:
 *           predefinedMetricType: KafkaBrokerStorageUtilization
 *         targetValue: 55
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Application AutoScaling Policy using the `service-namespace` , `resource-id`, `scalable-dimension` and `policy-name` separated by `/`. For example:
 * ```sh
 * $ pulumi import aws:appautoscaling/policy:Policy test-policy service-namespace/resource-id/scalable-dimension/policy-name
 * ```
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.aws.appautoscaling.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * List of CloudWatch alarm ARNs associated with the scaling policy.
     */
    public val alarmArns: Output<List<String>>
        get() = javaResource.alarmArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ARN assigned by AWS to the scaling policy.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the policy. Must be between 1 and 255 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs&#46;aws&#46;amazon&#46;com/autoscaling/application/userguide/application-auto-scaling-target-tracking&#46;html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
     */
    public val policyType: Output<String>?
        get() = javaResource.policyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    public val scalableDimension: Output<String>
        get() = javaResource.scalableDimension().applyValue({ args0 -> args0 })

    /**
     * AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
     */
    public val serviceNamespace: Output<String>
        get() = javaResource.serviceNamespace().applyValue({ args0 -> args0 })

    /**
     * Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
     */
    public val stepScalingPolicyConfiguration: Output<PolicyStepScalingPolicyConfiguration>?
        get() = javaResource.stepScalingPolicyConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> policyStepScalingPolicyConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
     */
    public val targetTrackingScalingPolicyConfiguration:
        Output<PolicyTargetTrackingScalingPolicyConfiguration>?
        get() = javaResource.targetTrackingScalingPolicyConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    policyTargetTrackingScalingPolicyConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appautoscaling.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.aws.appautoscaling.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
