@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.inputs

import com.pulumi.aws.appautoscaling.inputs.PolicyStepScalingPolicyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property adjustmentType Whether the adjustment is an absolute number or a percentage of the current capacity. Valid values are `ChangeInCapacity`, `ExactCapacity`, and `PercentChangeInCapacity`.
 * @property cooldown Amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
 * @property metricAggregationType Aggregation type for the policy's metrics. Valid values are "Minimum", "Maximum", and "Average". Without a value, AWS will treat the aggregation type as "Average".
 * @property minAdjustmentMagnitude Minimum number to adjust your scalable dimension as a result of a scaling activity. If the adjustment type is PercentChangeInCapacity, the scaling policy changes the scalable dimension of the scalable target by this amount.
 * @property stepAdjustments Set of adjustments that manage scaling. These have the following structure:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ecsPolicy = new aws.appautoscaling.Policy("ecs_policy", {stepScalingPolicyConfiguration: {
 *     stepAdjustments: [
 *         {
 *             metricIntervalLowerBound: "1",
 *             metricIntervalUpperBound: "2",
 *             scalingAdjustment: -1,
 *         },
 *         {
 *             metricIntervalLowerBound: "2",
 *             metricIntervalUpperBound: "3",
 *             scalingAdjustment: 1,
 *         },
 *     ],
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ecs_policy = aws.appautoscaling.Policy("ecs_policy", step_scaling_policy_configuration={
 *     "step_adjustments": [
 *         {
 *             "metric_interval_lower_bound": "1",
 *             "metric_interval_upper_bound": "2",
 *             "scaling_adjustment": -1,
 *         },
 *         {
 *             "metric_interval_lower_bound": "2",
 *             "metric_interval_upper_bound": "3",
 *             "scaling_adjustment": 1,
 *         },
 *     ],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ecsPolicy = new Aws.AppAutoScaling.Policy("ecs_policy", new()
 *     {
 *         StepScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationArgs
 *         {
 *             StepAdjustments = new[]
 *             {
 *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
 *                 {
 *                     MetricIntervalLowerBound = "1",
 *                     MetricIntervalUpperBound = "2",
 *                     ScalingAdjustment = -1,
 *                 },
 *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
 *                 {
 *                     MetricIntervalLowerBound = "2",
 *                     MetricIntervalUpperBound = "3",
 *                     ScalingAdjustment = 1,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appautoscaling.NewPolicy(ctx, "ecs_policy", &appautoscaling.PolicyArgs{
 * 			StepScalingPolicyConfiguration: &appautoscaling.PolicyStepScalingPolicyConfigurationArgs{
 * 				StepAdjustments: appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArray{
 * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
 * 						MetricIntervalLowerBound: pulumi.String("1"),
 * 						MetricIntervalUpperBound: pulumi.String("2"),
 * 						ScalingAdjustment:        int(-1),
 * 					},
 * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
 * 						MetricIntervalLowerBound: pulumi.String("2"),
 * 						MetricIntervalUpperBound: pulumi.String("3"),
 * 						ScalingAdjustment:        pulumi.Int(1),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   ecsPolicy:
 *     type: aws:appautoscaling:Policy
 *     name: ecs_policy
 *     properties:
 *       stepScalingPolicyConfiguration:
 *         stepAdjustments:
 *           - metricIntervalLowerBound: 1
 *             metricIntervalUpperBound: 2
 *             scalingAdjustment: -1
 *           - metricIntervalLowerBound: 2
 *             metricIntervalUpperBound: 3
 *             scalingAdjustment: 1
 * ```
 * <!--End PulumiCodeChooser -->
 */
public data class PolicyStepScalingPolicyConfigurationArgs(
    public val adjustmentType: Output<String>? = null,
    public val cooldown: Output<Int>? = null,
    public val metricAggregationType: Output<String>? = null,
    public val minAdjustmentMagnitude: Output<Int>? = null,
    public val stepAdjustments: Output<List<PolicyStepScalingPolicyConfigurationStepAdjustmentArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.appautoscaling.inputs.PolicyStepScalingPolicyConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.appautoscaling.inputs.PolicyStepScalingPolicyConfigurationArgs =
        com.pulumi.aws.appautoscaling.inputs.PolicyStepScalingPolicyConfigurationArgs.builder()
            .adjustmentType(adjustmentType?.applyValue({ args0 -> args0 }))
            .cooldown(cooldown?.applyValue({ args0 -> args0 }))
            .metricAggregationType(metricAggregationType?.applyValue({ args0 -> args0 }))
            .minAdjustmentMagnitude(minAdjustmentMagnitude?.applyValue({ args0 -> args0 }))
            .stepAdjustments(
                stepAdjustments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicyStepScalingPolicyConfigurationArgs].
 */
@PulumiTagMarker
public class PolicyStepScalingPolicyConfigurationArgsBuilder internal constructor() {
    private var adjustmentType: Output<String>? = null

    private var cooldown: Output<Int>? = null

    private var metricAggregationType: Output<String>? = null

    private var minAdjustmentMagnitude: Output<Int>? = null

    private var stepAdjustments: Output<List<PolicyStepScalingPolicyConfigurationStepAdjustmentArgs>>? =
        null

    /**
     * @param value Whether the adjustment is an absolute number or a percentage of the current capacity. Valid values are `ChangeInCapacity`, `ExactCapacity`, and `PercentChangeInCapacity`.
     */
    @JvmName("qsydlyrcyiteipwo")
    public suspend fun adjustmentType(`value`: Output<String>) {
        this.adjustmentType = value
    }

    /**
     * @param value Amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
     */
    @JvmName("kxvhcqqjlcdejaxr")
    public suspend fun cooldown(`value`: Output<Int>) {
        this.cooldown = value
    }

    /**
     * @param value Aggregation type for the policy's metrics. Valid values are "Minimum", "Maximum", and "Average". Without a value, AWS will treat the aggregation type as "Average".
     */
    @JvmName("qjjjikndwmjhbpvf")
    public suspend fun metricAggregationType(`value`: Output<String>) {
        this.metricAggregationType = value
    }

    /**
     * @param value Minimum number to adjust your scalable dimension as a result of a scaling activity. If the adjustment type is PercentChangeInCapacity, the scaling policy changes the scalable dimension of the scalable target by this amount.
     */
    @JvmName("vuttkxeoonilwgue")
    public suspend fun minAdjustmentMagnitude(`value`: Output<Int>) {
        this.minAdjustmentMagnitude = value
    }

    /**
     * @param value Set of adjustments that manage scaling. These have the following structure:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ecsPolicy = new aws.appautoscaling.Policy("ecs_policy", {stepScalingPolicyConfiguration: {
     *     stepAdjustments: [
     *         {
     *             metricIntervalLowerBound: "1",
     *             metricIntervalUpperBound: "2",
     *             scalingAdjustment: -1,
     *         },
     *         {
     *             metricIntervalLowerBound: "2",
     *             metricIntervalUpperBound: "3",
     *             scalingAdjustment: 1,
     *         },
     *     ],
     * }});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ecs_policy = aws.appautoscaling.Policy("ecs_policy", step_scaling_policy_configuration={
     *     "step_adjustments": [
     *         {
     *             "metric_interval_lower_bound": "1",
     *             "metric_interval_upper_bound": "2",
     *             "scaling_adjustment": -1,
     *         },
     *         {
     *             "metric_interval_lower_bound": "2",
     *             "metric_interval_upper_bound": "3",
     *             "scaling_adjustment": 1,
     *         },
     *     ],
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ecsPolicy = new Aws.AppAutoScaling.Policy("ecs_policy", new()
     *     {
     *         StepScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationArgs
     *         {
     *             StepAdjustments = new[]
     *             {
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "1",
     *                     MetricIntervalUpperBound = "2",
     *                     ScalingAdjustment = -1,
     *                 },
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "2",
     *                     MetricIntervalUpperBound = "3",
     *                     ScalingAdjustment = 1,
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appautoscaling.NewPolicy(ctx, "ecs_policy", &appautoscaling.PolicyArgs{
     * 			StepScalingPolicyConfiguration: &appautoscaling.PolicyStepScalingPolicyConfigurationArgs{
     * 				StepAdjustments: appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArray{
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("1"),
     * 						MetricIntervalUpperBound: pulumi.String("2"),
     * 						ScalingAdjustment:        int(-1),
     * 					},
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("2"),
     * 						MetricIntervalUpperBound: pulumi.String("3"),
     * 						ScalingAdjustment:        pulumi.Int(1),
     * 					},
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```yaml
     * resources:
     *   ecsPolicy:
     *     type: aws:appautoscaling:Policy
     *     name: ecs_policy
     *     properties:
     *       stepScalingPolicyConfiguration:
     *         stepAdjustments:
     *           - metricIntervalLowerBound: 1
     *             metricIntervalUpperBound: 2
     *             scalingAdjustment: -1
     *           - metricIntervalLowerBound: 2
     *             metricIntervalUpperBound: 3
     *             scalingAdjustment: 1
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("lpmtninqgpkhxxpq")
    public suspend fun stepAdjustments(`value`: Output<List<PolicyStepScalingPolicyConfigurationStepAdjustmentArgs>>) {
        this.stepAdjustments = value
    }

    @JvmName("ogewqhieygmyyacs")
    public suspend fun stepAdjustments(vararg values: Output<PolicyStepScalingPolicyConfigurationStepAdjustmentArgs>) {
        this.stepAdjustments = Output.all(values.asList())
    }

    /**
     * @param values Set of adjustments that manage scaling. These have the following structure:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ecsPolicy = new aws.appautoscaling.Policy("ecs_policy", {stepScalingPolicyConfiguration: {
     *     stepAdjustments: [
     *         {
     *             metricIntervalLowerBound: "1",
     *             metricIntervalUpperBound: "2",
     *             scalingAdjustment: -1,
     *         },
     *         {
     *             metricIntervalLowerBound: "2",
     *             metricIntervalUpperBound: "3",
     *             scalingAdjustment: 1,
     *         },
     *     ],
     * }});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ecs_policy = aws.appautoscaling.Policy("ecs_policy", step_scaling_policy_configuration={
     *     "step_adjustments": [
     *         {
     *             "metric_interval_lower_bound": "1",
     *             "metric_interval_upper_bound": "2",
     *             "scaling_adjustment": -1,
     *         },
     *         {
     *             "metric_interval_lower_bound": "2",
     *             "metric_interval_upper_bound": "3",
     *             "scaling_adjustment": 1,
     *         },
     *     ],
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ecsPolicy = new Aws.AppAutoScaling.Policy("ecs_policy", new()
     *     {
     *         StepScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationArgs
     *         {
     *             StepAdjustments = new[]
     *             {
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "1",
     *                     MetricIntervalUpperBound = "2",
     *                     ScalingAdjustment = -1,
     *                 },
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "2",
     *                     MetricIntervalUpperBound = "3",
     *                     ScalingAdjustment = 1,
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appautoscaling.NewPolicy(ctx, "ecs_policy", &appautoscaling.PolicyArgs{
     * 			StepScalingPolicyConfiguration: &appautoscaling.PolicyStepScalingPolicyConfigurationArgs{
     * 				StepAdjustments: appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArray{
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("1"),
     * 						MetricIntervalUpperBound: pulumi.String("2"),
     * 						ScalingAdjustment:        int(-1),
     * 					},
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("2"),
     * 						MetricIntervalUpperBound: pulumi.String("3"),
     * 						ScalingAdjustment:        pulumi.Int(1),
     * 					},
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```yaml
     * resources:
     *   ecsPolicy:
     *     type: aws:appautoscaling:Policy
     *     name: ecs_policy
     *     properties:
     *       stepScalingPolicyConfiguration:
     *         stepAdjustments:
     *           - metricIntervalLowerBound: 1
     *             metricIntervalUpperBound: 2
     *             scalingAdjustment: -1
     *           - metricIntervalLowerBound: 2
     *             metricIntervalUpperBound: 3
     *             scalingAdjustment: 1
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("aybpnqlemgjuawln")
    public suspend fun stepAdjustments(values: List<Output<PolicyStepScalingPolicyConfigurationStepAdjustmentArgs>>) {
        this.stepAdjustments = Output.all(values)
    }

    /**
     * @param value Whether the adjustment is an absolute number or a percentage of the current capacity. Valid values are `ChangeInCapacity`, `ExactCapacity`, and `PercentChangeInCapacity`.
     */
    @JvmName("pjrhamnyowifsems")
    public suspend fun adjustmentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adjustmentType = mapped
    }

    /**
     * @param value Amount of time, in seconds, after a scaling activity completes and before the next scaling activity can start.
     */
    @JvmName("liqreculfqfxlist")
    public suspend fun cooldown(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cooldown = mapped
    }

    /**
     * @param value Aggregation type for the policy's metrics. Valid values are "Minimum", "Maximum", and "Average". Without a value, AWS will treat the aggregation type as "Average".
     */
    @JvmName("mrpgggaaweccjqwg")
    public suspend fun metricAggregationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricAggregationType = mapped
    }

    /**
     * @param value Minimum number to adjust your scalable dimension as a result of a scaling activity. If the adjustment type is PercentChangeInCapacity, the scaling policy changes the scalable dimension of the scalable target by this amount.
     */
    @JvmName("gibxkedsfjkycrdw")
    public suspend fun minAdjustmentMagnitude(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minAdjustmentMagnitude = mapped
    }

    /**
     * @param value Set of adjustments that manage scaling. These have the following structure:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ecsPolicy = new aws.appautoscaling.Policy("ecs_policy", {stepScalingPolicyConfiguration: {
     *     stepAdjustments: [
     *         {
     *             metricIntervalLowerBound: "1",
     *             metricIntervalUpperBound: "2",
     *             scalingAdjustment: -1,
     *         },
     *         {
     *             metricIntervalLowerBound: "2",
     *             metricIntervalUpperBound: "3",
     *             scalingAdjustment: 1,
     *         },
     *     ],
     * }});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ecs_policy = aws.appautoscaling.Policy("ecs_policy", step_scaling_policy_configuration={
     *     "step_adjustments": [
     *         {
     *             "metric_interval_lower_bound": "1",
     *             "metric_interval_upper_bound": "2",
     *             "scaling_adjustment": -1,
     *         },
     *         {
     *             "metric_interval_lower_bound": "2",
     *             "metric_interval_upper_bound": "3",
     *             "scaling_adjustment": 1,
     *         },
     *     ],
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ecsPolicy = new Aws.AppAutoScaling.Policy("ecs_policy", new()
     *     {
     *         StepScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationArgs
     *         {
     *             StepAdjustments = new[]
     *             {
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "1",
     *                     MetricIntervalUpperBound = "2",
     *                     ScalingAdjustment = -1,
     *                 },
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "2",
     *                     MetricIntervalUpperBound = "3",
     *                     ScalingAdjustment = 1,
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appautoscaling.NewPolicy(ctx, "ecs_policy", &appautoscaling.PolicyArgs{
     * 			StepScalingPolicyConfiguration: &appautoscaling.PolicyStepScalingPolicyConfigurationArgs{
     * 				StepAdjustments: appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArray{
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("1"),
     * 						MetricIntervalUpperBound: pulumi.String("2"),
     * 						ScalingAdjustment:        int(-1),
     * 					},
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("2"),
     * 						MetricIntervalUpperBound: pulumi.String("3"),
     * 						ScalingAdjustment:        pulumi.Int(1),
     * 					},
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```yaml
     * resources:
     *   ecsPolicy:
     *     type: aws:appautoscaling:Policy
     *     name: ecs_policy
     *     properties:
     *       stepScalingPolicyConfiguration:
     *         stepAdjustments:
     *           - metricIntervalLowerBound: 1
     *             metricIntervalUpperBound: 2
     *             scalingAdjustment: -1
     *           - metricIntervalLowerBound: 2
     *             metricIntervalUpperBound: 3
     *             scalingAdjustment: 1
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("ohdwslapifynsroy")
    public suspend fun stepAdjustments(`value`: List<PolicyStepScalingPolicyConfigurationStepAdjustmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepAdjustments = mapped
    }

    /**
     * @param argument Set of adjustments that manage scaling. These have the following structure:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ecsPolicy = new aws.appautoscaling.Policy("ecs_policy", {stepScalingPolicyConfiguration: {
     *     stepAdjustments: [
     *         {
     *             metricIntervalLowerBound: "1",
     *             metricIntervalUpperBound: "2",
     *             scalingAdjustment: -1,
     *         },
     *         {
     *             metricIntervalLowerBound: "2",
     *             metricIntervalUpperBound: "3",
     *             scalingAdjustment: 1,
     *         },
     *     ],
     * }});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ecs_policy = aws.appautoscaling.Policy("ecs_policy", step_scaling_policy_configuration={
     *     "step_adjustments": [
     *         {
     *             "metric_interval_lower_bound": "1",
     *             "metric_interval_upper_bound": "2",
     *             "scaling_adjustment": -1,
     *         },
     *         {
     *             "metric_interval_lower_bound": "2",
     *             "metric_interval_upper_bound": "3",
     *             "scaling_adjustment": 1,
     *         },
     *     ],
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ecsPolicy = new Aws.AppAutoScaling.Policy("ecs_policy", new()
     *     {
     *         StepScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationArgs
     *         {
     *             StepAdjustments = new[]
     *             {
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "1",
     *                     MetricIntervalUpperBound = "2",
     *                     ScalingAdjustment = -1,
     *                 },
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "2",
     *                     MetricIntervalUpperBound = "3",
     *                     ScalingAdjustment = 1,
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appautoscaling.NewPolicy(ctx, "ecs_policy", &appautoscaling.PolicyArgs{
     * 			StepScalingPolicyConfiguration: &appautoscaling.PolicyStepScalingPolicyConfigurationArgs{
     * 				StepAdjustments: appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArray{
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("1"),
     * 						MetricIntervalUpperBound: pulumi.String("2"),
     * 						ScalingAdjustment:        int(-1),
     * 					},
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("2"),
     * 						MetricIntervalUpperBound: pulumi.String("3"),
     * 						ScalingAdjustment:        pulumi.Int(1),
     * 					},
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```yaml
     * resources:
     *   ecsPolicy:
     *     type: aws:appautoscaling:Policy
     *     name: ecs_policy
     *     properties:
     *       stepScalingPolicyConfiguration:
     *         stepAdjustments:
     *           - metricIntervalLowerBound: 1
     *             metricIntervalUpperBound: 2
     *             scalingAdjustment: -1
     *           - metricIntervalLowerBound: 2
     *             metricIntervalUpperBound: 3
     *             scalingAdjustment: 1
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("asslqvfrstyiujpl")
    public suspend fun stepAdjustments(argument: List<suspend PolicyStepScalingPolicyConfigurationStepAdjustmentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyStepScalingPolicyConfigurationStepAdjustmentArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stepAdjustments = mapped
    }

    /**
     * @param argument Set of adjustments that manage scaling. These have the following structure:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ecsPolicy = new aws.appautoscaling.Policy("ecs_policy", {stepScalingPolicyConfiguration: {
     *     stepAdjustments: [
     *         {
     *             metricIntervalLowerBound: "1",
     *             metricIntervalUpperBound: "2",
     *             scalingAdjustment: -1,
     *         },
     *         {
     *             metricIntervalLowerBound: "2",
     *             metricIntervalUpperBound: "3",
     *             scalingAdjustment: 1,
     *         },
     *     ],
     * }});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ecs_policy = aws.appautoscaling.Policy("ecs_policy", step_scaling_policy_configuration={
     *     "step_adjustments": [
     *         {
     *             "metric_interval_lower_bound": "1",
     *             "metric_interval_upper_bound": "2",
     *             "scaling_adjustment": -1,
     *         },
     *         {
     *             "metric_interval_lower_bound": "2",
     *             "metric_interval_upper_bound": "3",
     *             "scaling_adjustment": 1,
     *         },
     *     ],
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ecsPolicy = new Aws.AppAutoScaling.Policy("ecs_policy", new()
     *     {
     *         StepScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationArgs
     *         {
     *             StepAdjustments = new[]
     *             {
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "1",
     *                     MetricIntervalUpperBound = "2",
     *                     ScalingAdjustment = -1,
     *                 },
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "2",
     *                     MetricIntervalUpperBound = "3",
     *                     ScalingAdjustment = 1,
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appautoscaling.NewPolicy(ctx, "ecs_policy", &appautoscaling.PolicyArgs{
     * 			StepScalingPolicyConfiguration: &appautoscaling.PolicyStepScalingPolicyConfigurationArgs{
     * 				StepAdjustments: appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArray{
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("1"),
     * 						MetricIntervalUpperBound: pulumi.String("2"),
     * 						ScalingAdjustment:        int(-1),
     * 					},
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("2"),
     * 						MetricIntervalUpperBound: pulumi.String("3"),
     * 						ScalingAdjustment:        pulumi.Int(1),
     * 					},
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```yaml
     * resources:
     *   ecsPolicy:
     *     type: aws:appautoscaling:Policy
     *     name: ecs_policy
     *     properties:
     *       stepScalingPolicyConfiguration:
     *         stepAdjustments:
     *           - metricIntervalLowerBound: 1
     *             metricIntervalUpperBound: 2
     *             scalingAdjustment: -1
     *           - metricIntervalLowerBound: 2
     *             metricIntervalUpperBound: 3
     *             scalingAdjustment: 1
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("jiaisbyhlgrfvflq")
    public suspend fun stepAdjustments(vararg argument: suspend PolicyStepScalingPolicyConfigurationStepAdjustmentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyStepScalingPolicyConfigurationStepAdjustmentArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stepAdjustments = mapped
    }

    /**
     * @param argument Set of adjustments that manage scaling. These have the following structure:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ecsPolicy = new aws.appautoscaling.Policy("ecs_policy", {stepScalingPolicyConfiguration: {
     *     stepAdjustments: [
     *         {
     *             metricIntervalLowerBound: "1",
     *             metricIntervalUpperBound: "2",
     *             scalingAdjustment: -1,
     *         },
     *         {
     *             metricIntervalLowerBound: "2",
     *             metricIntervalUpperBound: "3",
     *             scalingAdjustment: 1,
     *         },
     *     ],
     * }});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ecs_policy = aws.appautoscaling.Policy("ecs_policy", step_scaling_policy_configuration={
     *     "step_adjustments": [
     *         {
     *             "metric_interval_lower_bound": "1",
     *             "metric_interval_upper_bound": "2",
     *             "scaling_adjustment": -1,
     *         },
     *         {
     *             "metric_interval_lower_bound": "2",
     *             "metric_interval_upper_bound": "3",
     *             "scaling_adjustment": 1,
     *         },
     *     ],
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ecsPolicy = new Aws.AppAutoScaling.Policy("ecs_policy", new()
     *     {
     *         StepScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationArgs
     *         {
     *             StepAdjustments = new[]
     *             {
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "1",
     *                     MetricIntervalUpperBound = "2",
     *                     ScalingAdjustment = -1,
     *                 },
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "2",
     *                     MetricIntervalUpperBound = "3",
     *                     ScalingAdjustment = 1,
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appautoscaling.NewPolicy(ctx, "ecs_policy", &appautoscaling.PolicyArgs{
     * 			StepScalingPolicyConfiguration: &appautoscaling.PolicyStepScalingPolicyConfigurationArgs{
     * 				StepAdjustments: appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArray{
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("1"),
     * 						MetricIntervalUpperBound: pulumi.String("2"),
     * 						ScalingAdjustment:        int(-1),
     * 					},
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("2"),
     * 						MetricIntervalUpperBound: pulumi.String("3"),
     * 						ScalingAdjustment:        pulumi.Int(1),
     * 					},
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```yaml
     * resources:
     *   ecsPolicy:
     *     type: aws:appautoscaling:Policy
     *     name: ecs_policy
     *     properties:
     *       stepScalingPolicyConfiguration:
     *         stepAdjustments:
     *           - metricIntervalLowerBound: 1
     *             metricIntervalUpperBound: 2
     *             scalingAdjustment: -1
     *           - metricIntervalLowerBound: 2
     *             metricIntervalUpperBound: 3
     *             scalingAdjustment: 1
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("dvsgvahbddjeywmr")
    public suspend fun stepAdjustments(argument: suspend PolicyStepScalingPolicyConfigurationStepAdjustmentArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyStepScalingPolicyConfigurationStepAdjustmentArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.stepAdjustments = mapped
    }

    /**
     * @param values Set of adjustments that manage scaling. These have the following structure:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ecsPolicy = new aws.appautoscaling.Policy("ecs_policy", {stepScalingPolicyConfiguration: {
     *     stepAdjustments: [
     *         {
     *             metricIntervalLowerBound: "1",
     *             metricIntervalUpperBound: "2",
     *             scalingAdjustment: -1,
     *         },
     *         {
     *             metricIntervalLowerBound: "2",
     *             metricIntervalUpperBound: "3",
     *             scalingAdjustment: 1,
     *         },
     *     ],
     * }});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ecs_policy = aws.appautoscaling.Policy("ecs_policy", step_scaling_policy_configuration={
     *     "step_adjustments": [
     *         {
     *             "metric_interval_lower_bound": "1",
     *             "metric_interval_upper_bound": "2",
     *             "scaling_adjustment": -1,
     *         },
     *         {
     *             "metric_interval_lower_bound": "2",
     *             "metric_interval_upper_bound": "3",
     *             "scaling_adjustment": 1,
     *         },
     *     ],
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ecsPolicy = new Aws.AppAutoScaling.Policy("ecs_policy", new()
     *     {
     *         StepScalingPolicyConfiguration = new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationArgs
     *         {
     *             StepAdjustments = new[]
     *             {
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "1",
     *                     MetricIntervalUpperBound = "2",
     *                     ScalingAdjustment = -1,
     *                 },
     *                 new Aws.AppAutoScaling.Inputs.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs
     *                 {
     *                     MetricIntervalLowerBound = "2",
     *                     MetricIntervalUpperBound = "3",
     *                     ScalingAdjustment = 1,
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appautoscaling"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := appautoscaling.NewPolicy(ctx, "ecs_policy", &appautoscaling.PolicyArgs{
     * 			StepScalingPolicyConfiguration: &appautoscaling.PolicyStepScalingPolicyConfigurationArgs{
     * 				StepAdjustments: appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArray{
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("1"),
     * 						MetricIntervalUpperBound: pulumi.String("2"),
     * 						ScalingAdjustment:        int(-1),
     * 					},
     * 					&appautoscaling.PolicyStepScalingPolicyConfigurationStepAdjustmentArgs{
     * 						MetricIntervalLowerBound: pulumi.String("2"),
     * 						MetricIntervalUpperBound: pulumi.String("3"),
     * 						ScalingAdjustment:        pulumi.Int(1),
     * 					},
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```yaml
     * resources:
     *   ecsPolicy:
     *     type: aws:appautoscaling:Policy
     *     name: ecs_policy
     *     properties:
     *       stepScalingPolicyConfiguration:
     *         stepAdjustments:
     *           - metricIntervalLowerBound: 1
     *             metricIntervalUpperBound: 2
     *             scalingAdjustment: -1
     *           - metricIntervalLowerBound: 2
     *             metricIntervalUpperBound: 3
     *             scalingAdjustment: 1
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("sqxnsrgyjovawweu")
    public suspend fun stepAdjustments(vararg values: PolicyStepScalingPolicyConfigurationStepAdjustmentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stepAdjustments = mapped
    }

    internal fun build(): PolicyStepScalingPolicyConfigurationArgs =
        PolicyStepScalingPolicyConfigurationArgs(
            adjustmentType = adjustmentType,
            cooldown = cooldown,
            metricAggregationType = metricAggregationType,
            minAdjustmentMagnitude = minAdjustmentMagnitude,
            stepAdjustments = stepAdjustments,
        )
}
