@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.inputs

import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dimensions Dimensions of the metric.
 * @property metricName Name of the metric.
 * @property metrics Metrics to include, as a metric data query.
 * @property namespace Namespace of the metric.
 * @property statistic Statistic of the metric. Valid values: `Average`, `Minimum`, `Maximum`, `SampleCount`, and `Sum`.
 * @property unit Unit of the metrics to return.
 */
public data class PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs(
    public val dimensions: Output<List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs>>? =
        null,
    public val metricName: Output<String>? = null,
    public val metrics: Output<List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs>>? =
        null,
    public val namespace: Output<String>? = null,
    public val statistic: Output<String>? = null,
    public val unit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs =
        com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs.builder()
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .metrics(
                metrics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .statistic(statistic?.applyValue({ args0 -> args0 }))
            .unit(unit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs].
 */
@PulumiTagMarker
public class PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgsBuilder
internal constructor() {
    private var dimensions:
        Output<List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs>>? =
        null

    private var metricName: Output<String>? = null

    private var metrics:
        Output<List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs>>? =
        null

    private var namespace: Output<String>? = null

    private var statistic: Output<String>? = null

    private var unit: Output<String>? = null

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("vcuwovrawsyxamfp")
    public suspend fun dimensions(`value`: Output<List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("mgychuhqolgkgyoh")
    public suspend fun dimensions(vararg values: Output<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("ciajvqpmuabwidts")
    public suspend fun dimensions(values: List<Output<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("ouhdmbhjntigohfl")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value Metrics to include, as a metric data query.
     */
    @JvmName("opcsmuoopxbvagkc")
    public suspend fun metrics(`value`: Output<List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs>>) {
        this.metrics = value
    }

    @JvmName("afkqclssvywlcsat")
    public suspend fun metrics(vararg values: Output<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs>) {
        this.metrics = Output.all(values.asList())
    }

    /**
     * @param values Metrics to include, as a metric data query.
     */
    @JvmName("irnfintgluwqfnnf")
    public suspend fun metrics(values: List<Output<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs>>) {
        this.metrics = Output.all(values)
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("ejuhoxiwyheaqoif")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Statistic of the metric. Valid values: `Average`, `Minimum`, `Maximum`, `SampleCount`, and `Sum`.
     */
    @JvmName("thpbwgmeislrkywm")
    public suspend fun statistic(`value`: Output<String>) {
        this.statistic = value
    }

    /**
     * @param value Unit of the metrics to return.
     */
    @JvmName("pgrjvtkmfoglctcu")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("jhqwoxennrkgnekf")
    public suspend fun dimensions(`value`: List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("qmaddubrdeyoulue")
    public suspend fun dimensions(argument: List<suspend PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("sojintmkbhnkaqid")
    public suspend fun dimensions(vararg argument: suspend PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("dkodnqrcnvotsxoy")
    public suspend fun dimensions(argument: suspend PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("bsegglwewjfipcpu")
    public suspend fun dimensions(vararg values: PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("syspesxgekcklmrw")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value Metrics to include, as a metric data query.
     */
    @JvmName("aierhwxnrpwvkfjt")
    public suspend fun metrics(`value`: List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param argument Metrics to include, as a metric data query.
     */
    @JvmName("akttyqboqnpkeyqd")
    public suspend fun metrics(argument: List<suspend PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Metrics to include, as a metric data query.
     */
    @JvmName("lfjgefecibqhlmtr")
    public suspend fun metrics(vararg argument: suspend PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Metrics to include, as a metric data query.
     */
    @JvmName("edihrjwyqaavycrn")
    public suspend fun metrics(argument: suspend PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param values Metrics to include, as a metric data query.
     */
    @JvmName("jngptyfofbxqgace")
    public suspend fun metrics(vararg values: PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("gkpcstcjisrcsgnj")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Statistic of the metric. Valid values: `Average`, `Minimum`, `Maximum`, `SampleCount`, and `Sum`.
     */
    @JvmName("hgneftiqfhgvcnep")
    public suspend fun statistic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statistic = mapped
    }

    /**
     * @param value Unit of the metrics to return.
     */
    @JvmName("twestlsbmarhgwff")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    internal fun build(): PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs =
        PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationArgs(
            dimensions = dimensions,
            metricName = metricName,
            metrics = metrics,
            namespace = namespace,
            statistic = statistic,
            unit = unit,
        )
}
