@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.inputs

import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the dimension.
 * @property value Value of the dimension.
 */
public data class
PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs> {
    override fun toJava(): com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs =
        com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs].
 */
@PulumiTagMarker
public class
PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgsBuilder
internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of the dimension.
     */
    @JvmName("qoexqofeoeqvqfgj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Value of the dimension.
     */
    @JvmName("oxnhjlychmomkkac")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of the dimension.
     */
    @JvmName("licejeyuedujpijj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Value of the dimension.
     */
    @JvmName("vreymixsabsyqilu")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs =
        PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensionArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
