@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.inputs

import com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dimensions Dimensions of the metric.
 * @property metricName Name of the metric.
 * @property namespace Namespace of the metric.
 */
public data class
PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs(
    public val dimensions: Output<List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>>? =
        null,
    public val metricName: Output<String>,
    public val namespace: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs> {
    override fun toJava(): com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs =
        com.pulumi.aws.appautoscaling.inputs.PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs.builder()
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .namespace(namespace.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs].
 */
@PulumiTagMarker
public class
PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgsBuilder
internal constructor() {
    private var dimensions:
        Output<List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>>? =
        null

    private var metricName: Output<String>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("vodrhcsovejyuvno")
    public suspend fun dimensions(`value`: Output<List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("betlknqqkdmvwxpb")
    public suspend fun dimensions(vararg values: Output<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("griwjfcruvapstpp")
    public suspend fun dimensions(values: List<Output<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("qkncekjdovnpxtjf")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("vbsjluwjbktlkkky")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("phtntlojrigqqcew")
    public suspend fun dimensions(`value`: List<PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("lgjfwdcdxohyhkag")
    public suspend fun dimensions(argument: List<suspend PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("nbtrfmqgvvgdqpgl")
    public suspend fun dimensions(vararg argument: suspend PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("peprddaaxecyqvot")
    public suspend fun dimensions(argument: suspend PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("unoonilkxauuymwr")
    public suspend fun dimensions(vararg values: PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("epdhenfvdicbokxu")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("fprsaouhbyonpdon")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs =
        PolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationMetricMetricStatMetricArgs(
            dimensions = dimensions,
            metricName = metricName ?: throw PulumiNullFieldException("metricName"),
            namespace = namespace ?: throw PulumiNullFieldException("namespace"),
        )
}
