@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.inputs

import com.pulumi.aws.appautoscaling.inputs.ScheduledActionScalableTargetActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxCapacity Maximum capacity. At least one of `max_capacity` or `min_capacity` must be set.
 * @property minCapacity Minimum capacity. At least one of `min_capacity` or `max_capacity` must be set.
 */
public data class ScheduledActionScalableTargetActionArgs(
    public val maxCapacity: Output<Int>? = null,
    public val minCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.appautoscaling.inputs.ScheduledActionScalableTargetActionArgs> {
    override fun toJava(): com.pulumi.aws.appautoscaling.inputs.ScheduledActionScalableTargetActionArgs =
        com.pulumi.aws.appautoscaling.inputs.ScheduledActionScalableTargetActionArgs.builder()
            .maxCapacity(maxCapacity?.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledActionScalableTargetActionArgs].
 */
@PulumiTagMarker
public class ScheduledActionScalableTargetActionArgsBuilder internal constructor() {
    private var maxCapacity: Output<Int>? = null

    private var minCapacity: Output<Int>? = null

    /**
     * @param value Maximum capacity. At least one of `max_capacity` or `min_capacity` must be set.
     */
    @JvmName("mayogxeyveiixovw")
    public suspend fun maxCapacity(`value`: Output<Int>) {
        this.maxCapacity = value
    }

    /**
     * @param value Minimum capacity. At least one of `min_capacity` or `max_capacity` must be set.
     */
    @JvmName("egcxhtecabtlyxug")
    public suspend fun minCapacity(`value`: Output<Int>) {
        this.minCapacity = value
    }

    /**
     * @param value Maximum capacity. At least one of `max_capacity` or `min_capacity` must be set.
     */
    @JvmName("aeggawsftakgwucy")
    public suspend fun maxCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value Minimum capacity. At least one of `min_capacity` or `max_capacity` must be set.
     */
    @JvmName("dlmtobncykwaifxf")
    public suspend fun minCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    internal fun build(): ScheduledActionScalableTargetActionArgs =
        ScheduledActionScalableTargetActionArgs(
            maxCapacity = maxCapacity,
            minCapacity = minCapacity,
        )
}
