@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property metricIntervalLowerBound Lower bound for the difference between the alarm threshold and the CloudWatch metric. Without a value, AWS will treat this bound as negative infinity.
 * @property metricIntervalUpperBound Upper bound for the difference between the alarm threshold and the CloudWatch metric. Without a value, AWS will treat this bound as infinity. The upper bound must be greater than the lower bound.
 * @property scalingAdjustment Number of members by which to scale, when the adjustment bounds are breached. A positive value scales up. A negative value scales down.
 */
public data class PolicyStepScalingPolicyConfigurationStepAdjustment(
    public val metricIntervalLowerBound: String? = null,
    public val metricIntervalUpperBound: String? = null,
    public val scalingAdjustment: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appautoscaling.outputs.PolicyStepScalingPolicyConfigurationStepAdjustment): PolicyStepScalingPolicyConfigurationStepAdjustment =
            PolicyStepScalingPolicyConfigurationStepAdjustment(
                metricIntervalLowerBound = javaType.metricIntervalLowerBound().map({ args0 -> args0 }).orElse(null),
                metricIntervalUpperBound = javaType.metricIntervalUpperBound().map({ args0 -> args0 }).orElse(null),
                scalingAdjustment = javaType.scalingAdjustment(),
            )
    }
}
