@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appautoscaling.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maxCapacity Maximum capacity. At least one of `max_capacity` or `min_capacity` must be set.
 * @property minCapacity Minimum capacity. At least one of `min_capacity` or `max_capacity` must be set.
 */
public data class ScheduledActionScalableTargetAction(
    public val maxCapacity: Int? = null,
    public val minCapacity: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appautoscaling.outputs.ScheduledActionScalableTargetAction): ScheduledActionScalableTargetAction = ScheduledActionScalableTargetAction(
            maxCapacity = javaType.maxCapacity().map({ args0 -> args0 }).orElse(null),
            minCapacity = javaType.minCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
