@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.kotlin.outputs.ConfigurationProfileValidator
import com.pulumi.aws.appconfig.kotlin.outputs.ConfigurationProfileValidator.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ConfigurationProfile].
 */
@PulumiTagMarker
public class ConfigurationProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationProfileArgs = ConfigurationProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationProfileArgsBuilder.() -> Unit) {
        val builder = ConfigurationProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConfigurationProfile {
        val builtJavaResource = com.pulumi.aws.appconfig.ConfigurationProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConfigurationProfile(builtJavaResource)
    }
}

/**
 * Provides an AppConfig Configuration Profile resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appconfig.ConfigurationProfile("example", {
 *     applicationId: exampleAwsAppconfigApplication.id,
 *     description: "Example Configuration Profile",
 *     name: "example-configuration-profile-tf",
 *     locationUri: "hosted",
 *     validators: [{
 *         content: exampleAwsLambdaFunction.arn,
 *         type: "LAMBDA",
 *     }],
 *     tags: {
 *         Type: "AppConfig Configuration Profile",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appconfig.ConfigurationProfile("example",
 *     application_id=example_aws_appconfig_application["id"],
 *     description="Example Configuration Profile",
 *     name="example-configuration-profile-tf",
 *     location_uri="hosted",
 *     validators=[{
 *         "content": example_aws_lambda_function["arn"],
 *         "type": "LAMBDA",
 *     }],
 *     tags={
 *         "Type": "AppConfig Configuration Profile",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppConfig.ConfigurationProfile("example", new()
 *     {
 *         ApplicationId = exampleAwsAppconfigApplication.Id,
 *         Description = "Example Configuration Profile",
 *         Name = "example-configuration-profile-tf",
 *         LocationUri = "hosted",
 *         Validators = new[]
 *         {
 *             new Aws.AppConfig.Inputs.ConfigurationProfileValidatorArgs
 *             {
 *                 Content = exampleAwsLambdaFunction.Arn,
 *                 Type = "LAMBDA",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Type", "AppConfig Configuration Profile" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appconfig"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfig.NewConfigurationProfile(ctx, "example", &appconfig.ConfigurationProfileArgs{
 * 			ApplicationId: pulumi.Any(exampleAwsAppconfigApplication.Id),
 * 			Description:   pulumi.String("Example Configuration Profile"),
 * 			Name:          pulumi.String("example-configuration-profile-tf"),
 * 			LocationUri:   pulumi.String("hosted"),
 * 			Validators: appconfig.ConfigurationProfileValidatorArray{
 * 				&appconfig.ConfigurationProfileValidatorArgs{
 * 					Content: pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 					Type:    pulumi.String("LAMBDA"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Type": pulumi.String("AppConfig Configuration Profile"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.ConfigurationProfile;
 * import com.pulumi.aws.appconfig.ConfigurationProfileArgs;
 * import com.pulumi.aws.appconfig.inputs.ConfigurationProfileValidatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConfigurationProfile("example", ConfigurationProfileArgs.builder()
 *             .applicationId(exampleAwsAppconfigApplication.id())
 *             .description("Example Configuration Profile")
 *             .name("example-configuration-profile-tf")
 *             .locationUri("hosted")
 *             .validators(ConfigurationProfileValidatorArgs.builder()
 *                 .content(exampleAwsLambdaFunction.arn())
 *                 .type("LAMBDA")
 *                 .build())
 *             .tags(Map.of("Type", "AppConfig Configuration Profile"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appconfig:ConfigurationProfile
 *     properties:
 *       applicationId: ${exampleAwsAppconfigApplication.id}
 *       description: Example Configuration Profile
 *       name: example-configuration-profile-tf
 *       locationUri: hosted
 *       validators:
 *         - content: ${exampleAwsLambdaFunction.arn}
 *           type: LAMBDA
 *       tags:
 *         Type: AppConfig Configuration Profile
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppConfig Configuration Profiles using the configuration profile ID and application ID separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:appconfig/configurationProfile:ConfigurationProfile example 71abcde:11xxxxx
 * ```
 */
public class ConfigurationProfile internal constructor(
    override val javaResource: com.pulumi.aws.appconfig.ConfigurationProfile,
) : KotlinCustomResource(javaResource, ConfigurationProfileMapper) {
    /**
     * Application ID. Must be between 4 and 7 characters in length.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * ARN of the AppConfig Configuration Profile.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The configuration profile ID.
     */
    public val configurationProfileId: Output<String>
        get() = javaResource.configurationProfileId().applyValue({ args0 -> args0 })

    /**
     * Description of the configuration profile. Can be at most 1024 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identifier for an Key Management Service key to encrypt new configuration data versions in the AppConfig hosted configuration store. This attribute is only used for hosted configuration types. The identifier can be an KMS key ID, alias, or the Amazon Resource Name (ARN) of the key ID or alias.
     */
    public val kmsKeyIdentifier: Output<String>?
        get() = javaResource.kmsKeyIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * URI to locate the configuration. You can specify the AWS AppConfig hosted configuration store, Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store, specify `hosted`. For an SSM document, specify either the document name in the format `ssm-document://<Document_name>` or the ARN. For a parameter, specify either the parameter name in the format `ssm-parameter://<Parameter_name>` or the ARN. For an Amazon S3 object, specify the URI in the following format: `s3://<bucket>/<objectKey>`.
     */
    public val locationUri: Output<String>
        get() = javaResource.locationUri().applyValue({ args0 -> args0 })

    /**
     * Name for the configuration profile. Must be between 1 and 128 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ARN of an IAM role with permission to access the configuration at the specified `location_uri`. A retrieval role ARN is not required for configurations stored in the AWS AppConfig `hosted` configuration store. It is required for all other sources that store your configuration.
     */
    public val retrievalRoleArn: Output<String>?
        get() = javaResource.retrievalRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Type of configurations contained in the profile. Valid values: `AWS.AppConfig.FeatureFlags` and `AWS.Freeform`.  Default: `AWS.Freeform`.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Set of methods for validating the configuration. Maximum of 2. See Validator below for more details.
     */
    public val validators: Output<List<ConfigurationProfileValidator>>?
        get() = javaResource.validators().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object ConfigurationProfileMapper : ResourceMapper<ConfigurationProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appconfig.ConfigurationProfile::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationProfile = ConfigurationProfile(
        javaResource
            as com.pulumi.aws.appconfig.ConfigurationProfile,
    )
}

/**
 * @see [ConfigurationProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationProfile].
 */
public suspend fun configurationProfile(
    name: String,
    block: suspend ConfigurationProfileResourceBuilder.() -> Unit,
): ConfigurationProfile {
    val builder = ConfigurationProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationProfile(name: String): ConfigurationProfile {
    val builder = ConfigurationProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
