@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.ConfigurationProfileArgs.builder
import com.pulumi.aws.appconfig.kotlin.inputs.ConfigurationProfileValidatorArgs
import com.pulumi.aws.appconfig.kotlin.inputs.ConfigurationProfileValidatorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppConfig Configuration Profile resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appconfig.ConfigurationProfile("example", {
 *     applicationId: exampleAwsAppconfigApplication.id,
 *     description: "Example Configuration Profile",
 *     name: "example-configuration-profile-tf",
 *     locationUri: "hosted",
 *     validators: [{
 *         content: exampleAwsLambdaFunction.arn,
 *         type: "LAMBDA",
 *     }],
 *     tags: {
 *         Type: "AppConfig Configuration Profile",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appconfig.ConfigurationProfile("example",
 *     application_id=example_aws_appconfig_application["id"],
 *     description="Example Configuration Profile",
 *     name="example-configuration-profile-tf",
 *     location_uri="hosted",
 *     validators=[{
 *         "content": example_aws_lambda_function["arn"],
 *         "type": "LAMBDA",
 *     }],
 *     tags={
 *         "Type": "AppConfig Configuration Profile",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppConfig.ConfigurationProfile("example", new()
 *     {
 *         ApplicationId = exampleAwsAppconfigApplication.Id,
 *         Description = "Example Configuration Profile",
 *         Name = "example-configuration-profile-tf",
 *         LocationUri = "hosted",
 *         Validators = new[]
 *         {
 *             new Aws.AppConfig.Inputs.ConfigurationProfileValidatorArgs
 *             {
 *                 Content = exampleAwsLambdaFunction.Arn,
 *                 Type = "LAMBDA",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Type", "AppConfig Configuration Profile" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appconfig"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfig.NewConfigurationProfile(ctx, "example", &appconfig.ConfigurationProfileArgs{
 * 			ApplicationId: pulumi.Any(exampleAwsAppconfigApplication.Id),
 * 			Description:   pulumi.String("Example Configuration Profile"),
 * 			Name:          pulumi.String("example-configuration-profile-tf"),
 * 			LocationUri:   pulumi.String("hosted"),
 * 			Validators: appconfig.ConfigurationProfileValidatorArray{
 * 				&appconfig.ConfigurationProfileValidatorArgs{
 * 					Content: pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 					Type:    pulumi.String("LAMBDA"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Type": pulumi.String("AppConfig Configuration Profile"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.ConfigurationProfile;
 * import com.pulumi.aws.appconfig.ConfigurationProfileArgs;
 * import com.pulumi.aws.appconfig.inputs.ConfigurationProfileValidatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConfigurationProfile("example", ConfigurationProfileArgs.builder()
 *             .applicationId(exampleAwsAppconfigApplication.id())
 *             .description("Example Configuration Profile")
 *             .name("example-configuration-profile-tf")
 *             .locationUri("hosted")
 *             .validators(ConfigurationProfileValidatorArgs.builder()
 *                 .content(exampleAwsLambdaFunction.arn())
 *                 .type("LAMBDA")
 *                 .build())
 *             .tags(Map.of("Type", "AppConfig Configuration Profile"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appconfig:ConfigurationProfile
 *     properties:
 *       applicationId: ${exampleAwsAppconfigApplication.id}
 *       description: Example Configuration Profile
 *       name: example-configuration-profile-tf
 *       locationUri: hosted
 *       validators:
 *         - content: ${exampleAwsLambdaFunction.arn}
 *           type: LAMBDA
 *       tags:
 *         Type: AppConfig Configuration Profile
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppConfig Configuration Profiles using the configuration profile ID and application ID separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:appconfig/configurationProfile:ConfigurationProfile example 71abcde:11xxxxx
 * ```
 * @property applicationId Application ID. Must be between 4 and 7 characters in length.
 * @property description Description of the configuration profile. Can be at most 1024 characters.
 * @property kmsKeyIdentifier The identifier for an Key Management Service key to encrypt new configuration data versions in the AppConfig hosted configuration store. This attribute is only used for hosted configuration types. The identifier can be an KMS key ID, alias, or the Amazon Resource Name (ARN) of the key ID or alias.
 * @property locationUri URI to locate the configuration. You can specify the AWS AppConfig hosted configuration store, Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store, specify `hosted`. For an SSM document, specify either the document name in the format `ssm-document://<Document_name>` or the ARN. For a parameter, specify either the parameter name in the format `ssm-parameter://<Parameter_name>` or the ARN. For an Amazon S3 object, specify the URI in the following format: `s3://<bucket>/<objectKey>`.
 * @property name Name for the configuration profile. Must be between 1 and 128 characters in length.
 * @property retrievalRoleArn ARN of an IAM role with permission to access the configuration at the specified `location_uri`. A retrieval role ARN is not required for configurations stored in the AWS AppConfig `hosted` configuration store. It is required for all other sources that store your configuration.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type Type of configurations contained in the profile. Valid values: `AWS.AppConfig.FeatureFlags` and `AWS.Freeform`.  Default: `AWS.Freeform`.
 * @property validators Set of methods for validating the configuration. Maximum of 2. See Validator below for more details.
 */
public data class ConfigurationProfileArgs(
    public val applicationId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val kmsKeyIdentifier: Output<String>? = null,
    public val locationUri: Output<String>? = null,
    public val name: Output<String>? = null,
    public val retrievalRoleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val validators: Output<List<ConfigurationProfileValidatorArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.ConfigurationProfileArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.ConfigurationProfileArgs =
        com.pulumi.aws.appconfig.ConfigurationProfileArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsKeyIdentifier(kmsKeyIdentifier?.applyValue({ args0 -> args0 }))
            .locationUri(locationUri?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .retrievalRoleArn(retrievalRoleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .validators(
                validators?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationProfileArgs].
 */
@PulumiTagMarker
public class ConfigurationProfileArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var description: Output<String>? = null

    private var kmsKeyIdentifier: Output<String>? = null

    private var locationUri: Output<String>? = null

    private var name: Output<String>? = null

    private var retrievalRoleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var validators: Output<List<ConfigurationProfileValidatorArgs>>? = null

    /**
     * @param value Application ID. Must be between 4 and 7 characters in length.
     */
    @JvmName("cwuvoukfiaicfbmd")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Description of the configuration profile. Can be at most 1024 characters.
     */
    @JvmName("csudthimtlgbgqyu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The identifier for an Key Management Service key to encrypt new configuration data versions in the AppConfig hosted configuration store. This attribute is only used for hosted configuration types. The identifier can be an KMS key ID, alias, or the Amazon Resource Name (ARN) of the key ID or alias.
     */
    @JvmName("rxqofigcerxdydkx")
    public suspend fun kmsKeyIdentifier(`value`: Output<String>) {
        this.kmsKeyIdentifier = value
    }

    /**
     * @param value URI to locate the configuration. You can specify the AWS AppConfig hosted configuration store, Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store, specify `hosted`. For an SSM document, specify either the document name in the format `ssm-document://<Document_name>` or the ARN. For a parameter, specify either the parameter name in the format `ssm-parameter://<Parameter_name>` or the ARN. For an Amazon S3 object, specify the URI in the following format: `s3://<bucket>/<objectKey>`.
     */
    @JvmName("bompdpiynonokosv")
    public suspend fun locationUri(`value`: Output<String>) {
        this.locationUri = value
    }

    /**
     * @param value Name for the configuration profile. Must be between 1 and 128 characters in length.
     */
    @JvmName("rbtintfwncunochl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ARN of an IAM role with permission to access the configuration at the specified `location_uri`. A retrieval role ARN is not required for configurations stored in the AWS AppConfig `hosted` configuration store. It is required for all other sources that store your configuration.
     */
    @JvmName("awgofhwfftfvgltc")
    public suspend fun retrievalRoleArn(`value`: Output<String>) {
        this.retrievalRoleArn = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hvbxefppojgsdiua")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Type of configurations contained in the profile. Valid values: `AWS.AppConfig.FeatureFlags` and `AWS.Freeform`.  Default: `AWS.Freeform`.
     */
    @JvmName("ioogqslphbaqsdsa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Set of methods for validating the configuration. Maximum of 2. See Validator below for more details.
     */
    @JvmName("upmvnwgdcxpbxuef")
    public suspend fun validators(`value`: Output<List<ConfigurationProfileValidatorArgs>>) {
        this.validators = value
    }

    @JvmName("qxatocbwyexcjjcs")
    public suspend fun validators(vararg values: Output<ConfigurationProfileValidatorArgs>) {
        this.validators = Output.all(values.asList())
    }

    /**
     * @param values Set of methods for validating the configuration. Maximum of 2. See Validator below for more details.
     */
    @JvmName("caamdjnhkqkocfmb")
    public suspend fun validators(values: List<Output<ConfigurationProfileValidatorArgs>>) {
        this.validators = Output.all(values)
    }

    /**
     * @param value Application ID. Must be between 4 and 7 characters in length.
     */
    @JvmName("xmviptiesfonhwuj")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Description of the configuration profile. Can be at most 1024 characters.
     */
    @JvmName("sxrkpueixihpiibd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The identifier for an Key Management Service key to encrypt new configuration data versions in the AppConfig hosted configuration store. This attribute is only used for hosted configuration types. The identifier can be an KMS key ID, alias, or the Amazon Resource Name (ARN) of the key ID or alias.
     */
    @JvmName("ocbmvdvsmmxvdsly")
    public suspend fun kmsKeyIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyIdentifier = mapped
    }

    /**
     * @param value URI to locate the configuration. You can specify the AWS AppConfig hosted configuration store, Systems Manager (SSM) document, an SSM Parameter Store parameter, or an Amazon S3 object. For the hosted configuration store, specify `hosted`. For an SSM document, specify either the document name in the format `ssm-document://<Document_name>` or the ARN. For a parameter, specify either the parameter name in the format `ssm-parameter://<Parameter_name>` or the ARN. For an Amazon S3 object, specify the URI in the following format: `s3://<bucket>/<objectKey>`.
     */
    @JvmName("skxibpiehacuyhsb")
    public suspend fun locationUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationUri = mapped
    }

    /**
     * @param value Name for the configuration profile. Must be between 1 and 128 characters in length.
     */
    @JvmName("tktrknndvgcvnlft")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ARN of an IAM role with permission to access the configuration at the specified `location_uri`. A retrieval role ARN is not required for configurations stored in the AWS AppConfig `hosted` configuration store. It is required for all other sources that store your configuration.
     */
    @JvmName("fmbiilcmonvisoue")
    public suspend fun retrievalRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retrievalRoleArn = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eunrnqtjvkhltjda")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ripfdetifvpdvhvd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Type of configurations contained in the profile. Valid values: `AWS.AppConfig.FeatureFlags` and `AWS.Freeform`.  Default: `AWS.Freeform`.
     */
    @JvmName("emrumjrsjinyplme")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Set of methods for validating the configuration. Maximum of 2. See Validator below for more details.
     */
    @JvmName("yrhawpufsiujklmk")
    public suspend fun validators(`value`: List<ConfigurationProfileValidatorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validators = mapped
    }

    /**
     * @param argument Set of methods for validating the configuration. Maximum of 2. See Validator below for more details.
     */
    @JvmName("cotqprcmpmxjmfqf")
    public suspend fun validators(argument: List<suspend ConfigurationProfileValidatorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConfigurationProfileValidatorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.validators = mapped
    }

    /**
     * @param argument Set of methods for validating the configuration. Maximum of 2. See Validator below for more details.
     */
    @JvmName("nkrlmsonmxhyrdhj")
    public suspend fun validators(vararg argument: suspend ConfigurationProfileValidatorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConfigurationProfileValidatorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.validators = mapped
    }

    /**
     * @param argument Set of methods for validating the configuration. Maximum of 2. See Validator below for more details.
     */
    @JvmName("fiekmwsfajcaolrt")
    public suspend fun validators(argument: suspend ConfigurationProfileValidatorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConfigurationProfileValidatorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.validators = mapped
    }

    /**
     * @param values Set of methods for validating the configuration. Maximum of 2. See Validator below for more details.
     */
    @JvmName("liopgdienmpgdart")
    public suspend fun validators(vararg values: ConfigurationProfileValidatorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validators = mapped
    }

    internal fun build(): ConfigurationProfileArgs = ConfigurationProfileArgs(
        applicationId = applicationId,
        description = description,
        kmsKeyIdentifier = kmsKeyIdentifier,
        locationUri = locationUri,
        name = name,
        retrievalRoleArn = retrievalRoleArn,
        tags = tags,
        type = type,
        validators = validators,
    )
}
