@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Deployment].
 */
@PulumiTagMarker
public class DeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentArgs = DeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentArgsBuilder.() -> Unit) {
        val builder = DeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Deployment {
        val builtJavaResource = com.pulumi.aws.appconfig.Deployment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Deployment(builtJavaResource)
    }
}

/**
 * Provides an AppConfig Deployment resource for an `aws.appconfig.Application` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appconfig.Deployment("example", {
 *     applicationId: exampleAwsAppconfigApplication.id,
 *     configurationProfileId: exampleAwsAppconfigConfigurationProfile.configurationProfileId,
 *     configurationVersion: exampleAwsAppconfigHostedConfigurationVersion.versionNumber,
 *     deploymentStrategyId: exampleAwsAppconfigDeploymentStrategy.id,
 *     description: "My example deployment",
 *     environmentId: exampleAwsAppconfigEnvironment.environmentId,
 *     kmsKeyIdentifier: exampleAwsKmsKey.arn,
 *     tags: {
 *         Type: "AppConfig Deployment",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appconfig.Deployment("example",
 *     application_id=example_aws_appconfig_application["id"],
 *     configuration_profile_id=example_aws_appconfig_configuration_profile["configurationProfileId"],
 *     configuration_version=example_aws_appconfig_hosted_configuration_version["versionNumber"],
 *     deployment_strategy_id=example_aws_appconfig_deployment_strategy["id"],
 *     description="My example deployment",
 *     environment_id=example_aws_appconfig_environment["environmentId"],
 *     kms_key_identifier=example_aws_kms_key["arn"],
 *     tags={
 *         "Type": "AppConfig Deployment",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppConfig.Deployment("example", new()
 *     {
 *         ApplicationId = exampleAwsAppconfigApplication.Id,
 *         ConfigurationProfileId = exampleAwsAppconfigConfigurationProfile.ConfigurationProfileId,
 *         ConfigurationVersion = exampleAwsAppconfigHostedConfigurationVersion.VersionNumber,
 *         DeploymentStrategyId = exampleAwsAppconfigDeploymentStrategy.Id,
 *         Description = "My example deployment",
 *         EnvironmentId = exampleAwsAppconfigEnvironment.EnvironmentId,
 *         KmsKeyIdentifier = exampleAwsKmsKey.Arn,
 *         Tags =
 *         {
 *             { "Type", "AppConfig Deployment" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appconfig"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfig.NewDeployment(ctx, "example", &appconfig.DeploymentArgs{
 * 			ApplicationId:          pulumi.Any(exampleAwsAppconfigApplication.Id),
 * 			ConfigurationProfileId: pulumi.Any(exampleAwsAppconfigConfigurationProfile.ConfigurationProfileId),
 * 			ConfigurationVersion:   pulumi.Any(exampleAwsAppconfigHostedConfigurationVersion.VersionNumber),
 * 			DeploymentStrategyId:   pulumi.Any(exampleAwsAppconfigDeploymentStrategy.Id),
 * 			Description:            pulumi.String("My example deployment"),
 * 			EnvironmentId:          pulumi.Any(exampleAwsAppconfigEnvironment.EnvironmentId),
 * 			KmsKeyIdentifier:       pulumi.Any(exampleAwsKmsKey.Arn),
 * 			Tags: pulumi.StringMap{
 * 				"Type": pulumi.String("AppConfig Deployment"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.Deployment;
 * import com.pulumi.aws.appconfig.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Deployment("example", DeploymentArgs.builder()
 *             .applicationId(exampleAwsAppconfigApplication.id())
 *             .configurationProfileId(exampleAwsAppconfigConfigurationProfile.configurationProfileId())
 *             .configurationVersion(exampleAwsAppconfigHostedConfigurationVersion.versionNumber())
 *             .deploymentStrategyId(exampleAwsAppconfigDeploymentStrategy.id())
 *             .description("My example deployment")
 *             .environmentId(exampleAwsAppconfigEnvironment.environmentId())
 *             .kmsKeyIdentifier(exampleAwsKmsKey.arn())
 *             .tags(Map.of("Type", "AppConfig Deployment"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appconfig:Deployment
 *     properties:
 *       applicationId: ${exampleAwsAppconfigApplication.id}
 *       configurationProfileId: ${exampleAwsAppconfigConfigurationProfile.configurationProfileId}
 *       configurationVersion: ${exampleAwsAppconfigHostedConfigurationVersion.versionNumber}
 *       deploymentStrategyId: ${exampleAwsAppconfigDeploymentStrategy.id}
 *       description: My example deployment
 *       environmentId: ${exampleAwsAppconfigEnvironment.environmentId}
 *       kmsKeyIdentifier: ${exampleAwsKmsKey.arn}
 *       tags:
 *         Type: AppConfig Deployment
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppConfig Deployments using the application ID, environment ID, and deployment number separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:appconfig/deployment:Deployment example 71abcde/11xxxxx/1
 * ```
 */
public class Deployment internal constructor(
    override val javaResource: com.pulumi.aws.appconfig.Deployment,
) : KotlinCustomResource(javaResource, DeploymentMapper) {
    /**
     * Application ID. Must be between 4 and 7 characters in length.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * ARN of the AppConfig Deployment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration profile ID. Must be between 4 and 7 characters in length.
     */
    public val configurationProfileId: Output<String>
        get() = javaResource.configurationProfileId().applyValue({ args0 -> args0 })

    /**
     * Configuration version to deploy. Can be at most 1024 characters.
     */
    public val configurationVersion: Output<String>
        get() = javaResource.configurationVersion().applyValue({ args0 -> args0 })

    /**
     * Deployment number.
     */
    public val deploymentNumber: Output<Int>
        get() = javaResource.deploymentNumber().applyValue({ args0 -> args0 })

    /**
     * Deployment strategy ID or name of a predefined deployment strategy. See [Predefined Deployment Strategies](https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html#appconfig-creating-deployment-strategy-predefined) for more details.
     */
    public val deploymentStrategyId: Output<String>
        get() = javaResource.deploymentStrategyId().applyValue({ args0 -> args0 })

    /**
     * Description of the deployment. Can be at most 1024 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Environment ID. Must be between 4 and 7 characters in length.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * ARN of the KMS key used to encrypt configuration data.
     */
    public val kmsKeyArn: Output<String>
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0 })

    /**
     * The KMS key identifier (key ID, key alias, or key ARN). AppConfig uses this to encrypt the configuration data using a customer managed key.
     */
    public val kmsKeyIdentifier: Output<String>?
        get() = javaResource.kmsKeyIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * State of the deployment.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DeploymentMapper : ResourceMapper<Deployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appconfig.Deployment::class == javaResource::class

    override fun map(javaResource: Resource): Deployment = Deployment(
        javaResource as
            com.pulumi.aws.appconfig.Deployment,
    )
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Deployment].
 */
public suspend fun deployment(name: String, block: suspend DeploymentResourceBuilder.() -> Unit): Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deployment(name: String): Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
