@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DeploymentStrategy].
 */
@PulumiTagMarker
public class DeploymentStrategyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentStrategyArgs = DeploymentStrategyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentStrategyArgsBuilder.() -> Unit) {
        val builder = DeploymentStrategyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeploymentStrategy {
        val builtJavaResource = com.pulumi.aws.appconfig.DeploymentStrategy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeploymentStrategy(builtJavaResource)
    }
}

/**
 * Provides an AppConfig Deployment Strategy resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appconfig.DeploymentStrategy("example", {
 *     name: "example-deployment-strategy-tf",
 *     description: "Example Deployment Strategy",
 *     deploymentDurationInMinutes: 3,
 *     finalBakeTimeInMinutes: 4,
 *     growthFactor: 10,
 *     growthType: "LINEAR",
 *     replicateTo: "NONE",
 *     tags: {
 *         Type: "AppConfig Deployment Strategy",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appconfig.DeploymentStrategy("example",
 *     name="example-deployment-strategy-tf",
 *     description="Example Deployment Strategy",
 *     deployment_duration_in_minutes=3,
 *     final_bake_time_in_minutes=4,
 *     growth_factor=10,
 *     growth_type="LINEAR",
 *     replicate_to="NONE",
 *     tags={
 *         "Type": "AppConfig Deployment Strategy",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppConfig.DeploymentStrategy("example", new()
 *     {
 *         Name = "example-deployment-strategy-tf",
 *         Description = "Example Deployment Strategy",
 *         DeploymentDurationInMinutes = 3,
 *         FinalBakeTimeInMinutes = 4,
 *         GrowthFactor = 10,
 *         GrowthType = "LINEAR",
 *         ReplicateTo = "NONE",
 *         Tags =
 *         {
 *             { "Type", "AppConfig Deployment Strategy" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appconfig"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfig.NewDeploymentStrategy(ctx, "example", &appconfig.DeploymentStrategyArgs{
 * 			Name:                        pulumi.String("example-deployment-strategy-tf"),
 * 			Description:                 pulumi.String("Example Deployment Strategy"),
 * 			DeploymentDurationInMinutes: pulumi.Int(3),
 * 			FinalBakeTimeInMinutes:      pulumi.Int(4),
 * 			GrowthFactor:                pulumi.Float64(10),
 * 			GrowthType:                  pulumi.String("LINEAR"),
 * 			ReplicateTo:                 pulumi.String("NONE"),
 * 			Tags: pulumi.StringMap{
 * 				"Type": pulumi.String("AppConfig Deployment Strategy"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.DeploymentStrategy;
 * import com.pulumi.aws.appconfig.DeploymentStrategyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DeploymentStrategy("example", DeploymentStrategyArgs.builder()
 *             .name("example-deployment-strategy-tf")
 *             .description("Example Deployment Strategy")
 *             .deploymentDurationInMinutes(3)
 *             .finalBakeTimeInMinutes(4)
 *             .growthFactor(10)
 *             .growthType("LINEAR")
 *             .replicateTo("NONE")
 *             .tags(Map.of("Type", "AppConfig Deployment Strategy"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appconfig:DeploymentStrategy
 *     properties:
 *       name: example-deployment-strategy-tf
 *       description: Example Deployment Strategy
 *       deploymentDurationInMinutes: 3
 *       finalBakeTimeInMinutes: 4
 *       growthFactor: 10
 *       growthType: LINEAR
 *       replicateTo: NONE
 *       tags:
 *         Type: AppConfig Deployment Strategy
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppConfig Deployment Strategies using their deployment strategy ID. For example:
 * ```sh
 * $ pulumi import aws:appconfig/deploymentStrategy:DeploymentStrategy example 11xxxxx
 * ```
 */
public class DeploymentStrategy internal constructor(
    override val javaResource: com.pulumi.aws.appconfig.DeploymentStrategy,
) : KotlinCustomResource(javaResource, DeploymentStrategyMapper) {
    /**
     * ARN of the AppConfig Deployment Strategy.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Total amount of time for a deployment to last. Minimum value of 0, maximum value of 1440.
     */
    public val deploymentDurationInMinutes: Output<Int>
        get() = javaResource.deploymentDurationInMinutes().applyValue({ args0 -> args0 })

    /**
     * Description of the deployment strategy. Can be at most 1024 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amount of time AWS AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back. Minimum value of 0, maximum value of 1440.
     */
    public val finalBakeTimeInMinutes: Output<Int>?
        get() = javaResource.finalBakeTimeInMinutes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Percentage of targets to receive a deployed configuration during each interval. Minimum value of 1.0, maximum value of 100.0.
     */
    public val growthFactor: Output<Double>
        get() = javaResource.growthFactor().applyValue({ args0 -> args0 })

    /**
     * Algorithm used to define how percentage grows over time. Valid value: `LINEAR` and `EXPONENTIAL`. Defaults to `LINEAR`.
     */
    public val growthType: Output<String>?
        get() = javaResource.growthType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name for the deployment strategy. Must be between 1 and 64 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Where to save the deployment strategy. Valid values: `NONE` and `SSM_DOCUMENT`.
     */
    public val replicateTo: Output<String>
        get() = javaResource.replicateTo().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DeploymentStrategyMapper : ResourceMapper<DeploymentStrategy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appconfig.DeploymentStrategy::class == javaResource::class

    override fun map(javaResource: Resource): DeploymentStrategy = DeploymentStrategy(
        javaResource as
            com.pulumi.aws.appconfig.DeploymentStrategy,
    )
}

/**
 * @see [DeploymentStrategy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeploymentStrategy].
 */
public suspend fun deploymentStrategy(
    name: String,
    block: suspend DeploymentStrategyResourceBuilder.() -> Unit,
): DeploymentStrategy {
    val builder = DeploymentStrategyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeploymentStrategy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deploymentStrategy(name: String): DeploymentStrategy {
    val builder = DeploymentStrategyResourceBuilder()
    builder.name(name)
    return builder.build()
}
