@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.DeploymentStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppConfig Deployment Strategy resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appconfig.DeploymentStrategy("example", {
 *     name: "example-deployment-strategy-tf",
 *     description: "Example Deployment Strategy",
 *     deploymentDurationInMinutes: 3,
 *     finalBakeTimeInMinutes: 4,
 *     growthFactor: 10,
 *     growthType: "LINEAR",
 *     replicateTo: "NONE",
 *     tags: {
 *         Type: "AppConfig Deployment Strategy",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appconfig.DeploymentStrategy("example",
 *     name="example-deployment-strategy-tf",
 *     description="Example Deployment Strategy",
 *     deployment_duration_in_minutes=3,
 *     final_bake_time_in_minutes=4,
 *     growth_factor=10,
 *     growth_type="LINEAR",
 *     replicate_to="NONE",
 *     tags={
 *         "Type": "AppConfig Deployment Strategy",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppConfig.DeploymentStrategy("example", new()
 *     {
 *         Name = "example-deployment-strategy-tf",
 *         Description = "Example Deployment Strategy",
 *         DeploymentDurationInMinutes = 3,
 *         FinalBakeTimeInMinutes = 4,
 *         GrowthFactor = 10,
 *         GrowthType = "LINEAR",
 *         ReplicateTo = "NONE",
 *         Tags =
 *         {
 *             { "Type", "AppConfig Deployment Strategy" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appconfig"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfig.NewDeploymentStrategy(ctx, "example", &appconfig.DeploymentStrategyArgs{
 * 			Name:                        pulumi.String("example-deployment-strategy-tf"),
 * 			Description:                 pulumi.String("Example Deployment Strategy"),
 * 			DeploymentDurationInMinutes: pulumi.Int(3),
 * 			FinalBakeTimeInMinutes:      pulumi.Int(4),
 * 			GrowthFactor:                pulumi.Float64(10),
 * 			GrowthType:                  pulumi.String("LINEAR"),
 * 			ReplicateTo:                 pulumi.String("NONE"),
 * 			Tags: pulumi.StringMap{
 * 				"Type": pulumi.String("AppConfig Deployment Strategy"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.DeploymentStrategy;
 * import com.pulumi.aws.appconfig.DeploymentStrategyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DeploymentStrategy("example", DeploymentStrategyArgs.builder()
 *             .name("example-deployment-strategy-tf")
 *             .description("Example Deployment Strategy")
 *             .deploymentDurationInMinutes(3)
 *             .finalBakeTimeInMinutes(4)
 *             .growthFactor(10)
 *             .growthType("LINEAR")
 *             .replicateTo("NONE")
 *             .tags(Map.of("Type", "AppConfig Deployment Strategy"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appconfig:DeploymentStrategy
 *     properties:
 *       name: example-deployment-strategy-tf
 *       description: Example Deployment Strategy
 *       deploymentDurationInMinutes: 3
 *       finalBakeTimeInMinutes: 4
 *       growthFactor: 10
 *       growthType: LINEAR
 *       replicateTo: NONE
 *       tags:
 *         Type: AppConfig Deployment Strategy
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppConfig Deployment Strategies using their deployment strategy ID. For example:
 * ```sh
 * $ pulumi import aws:appconfig/deploymentStrategy:DeploymentStrategy example 11xxxxx
 * ```
 * @property deploymentDurationInMinutes Total amount of time for a deployment to last. Minimum value of 0, maximum value of 1440.
 * @property description Description of the deployment strategy. Can be at most 1024 characters.
 * @property finalBakeTimeInMinutes Amount of time AWS AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back. Minimum value of 0, maximum value of 1440.
 * @property growthFactor Percentage of targets to receive a deployed configuration during each interval. Minimum value of 1.0, maximum value of 100.0.
 * @property growthType Algorithm used to define how percentage grows over time. Valid value: `LINEAR` and `EXPONENTIAL`. Defaults to `LINEAR`.
 * @property name Name for the deployment strategy. Must be between 1 and 64 characters in length.
 * @property replicateTo Where to save the deployment strategy. Valid values: `NONE` and `SSM_DOCUMENT`.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DeploymentStrategyArgs(
    public val deploymentDurationInMinutes: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val finalBakeTimeInMinutes: Output<Int>? = null,
    public val growthFactor: Output<Double>? = null,
    public val growthType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val replicateTo: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.DeploymentStrategyArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.DeploymentStrategyArgs =
        com.pulumi.aws.appconfig.DeploymentStrategyArgs.builder()
            .deploymentDurationInMinutes(deploymentDurationInMinutes?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .finalBakeTimeInMinutes(finalBakeTimeInMinutes?.applyValue({ args0 -> args0 }))
            .growthFactor(growthFactor?.applyValue({ args0 -> args0 }))
            .growthType(growthType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .replicateTo(replicateTo?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DeploymentStrategyArgs].
 */
@PulumiTagMarker
public class DeploymentStrategyArgsBuilder internal constructor() {
    private var deploymentDurationInMinutes: Output<Int>? = null

    private var description: Output<String>? = null

    private var finalBakeTimeInMinutes: Output<Int>? = null

    private var growthFactor: Output<Double>? = null

    private var growthType: Output<String>? = null

    private var name: Output<String>? = null

    private var replicateTo: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Total amount of time for a deployment to last. Minimum value of 0, maximum value of 1440.
     */
    @JvmName("qutkftnwowqqabjo")
    public suspend fun deploymentDurationInMinutes(`value`: Output<Int>) {
        this.deploymentDurationInMinutes = value
    }

    /**
     * @param value Description of the deployment strategy. Can be at most 1024 characters.
     */
    @JvmName("teagabowdsevxnkf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Amount of time AWS AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back. Minimum value of 0, maximum value of 1440.
     */
    @JvmName("ingkmqccygnwbmrw")
    public suspend fun finalBakeTimeInMinutes(`value`: Output<Int>) {
        this.finalBakeTimeInMinutes = value
    }

    /**
     * @param value Percentage of targets to receive a deployed configuration during each interval. Minimum value of 1.0, maximum value of 100.0.
     */
    @JvmName("pponbalewyrkwjpd")
    public suspend fun growthFactor(`value`: Output<Double>) {
        this.growthFactor = value
    }

    /**
     * @param value Algorithm used to define how percentage grows over time. Valid value: `LINEAR` and `EXPONENTIAL`. Defaults to `LINEAR`.
     */
    @JvmName("wyvkfcrnfcbovtec")
    public suspend fun growthType(`value`: Output<String>) {
        this.growthType = value
    }

    /**
     * @param value Name for the deployment strategy. Must be between 1 and 64 characters in length.
     */
    @JvmName("phqjxlxyxwpchhmt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Where to save the deployment strategy. Valid values: `NONE` and `SSM_DOCUMENT`.
     */
    @JvmName("lboevopjksqxlqxs")
    public suspend fun replicateTo(`value`: Output<String>) {
        this.replicateTo = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yjvchahbmjbqbfth")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Total amount of time for a deployment to last. Minimum value of 0, maximum value of 1440.
     */
    @JvmName("gpnpucniqkuwrptu")
    public suspend fun deploymentDurationInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentDurationInMinutes = mapped
    }

    /**
     * @param value Description of the deployment strategy. Can be at most 1024 characters.
     */
    @JvmName("eqrpwjhaqdakucif")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Amount of time AWS AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic roll back. Minimum value of 0, maximum value of 1440.
     */
    @JvmName("hwnkaomquekjreww")
    public suspend fun finalBakeTimeInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finalBakeTimeInMinutes = mapped
    }

    /**
     * @param value Percentage of targets to receive a deployed configuration during each interval. Minimum value of 1.0, maximum value of 100.0.
     */
    @JvmName("unekdsrachfsdqlt")
    public suspend fun growthFactor(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.growthFactor = mapped
    }

    /**
     * @param value Algorithm used to define how percentage grows over time. Valid value: `LINEAR` and `EXPONENTIAL`. Defaults to `LINEAR`.
     */
    @JvmName("epyhncmlqqudpggn")
    public suspend fun growthType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.growthType = mapped
    }

    /**
     * @param value Name for the deployment strategy. Must be between 1 and 64 characters in length.
     */
    @JvmName("tdiratxjorxpchth")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Where to save the deployment strategy. Valid values: `NONE` and `SSM_DOCUMENT`.
     */
    @JvmName("kaegkihvvteqbujk")
    public suspend fun replicateTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicateTo = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("txbbgyialixxvnuc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("njmkjugdbgxvyksx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DeploymentStrategyArgs = DeploymentStrategyArgs(
        deploymentDurationInMinutes = deploymentDurationInMinutes,
        description = description,
        finalBakeTimeInMinutes = finalBakeTimeInMinutes,
        growthFactor = growthFactor,
        growthType = growthType,
        name = name,
        replicateTo = replicateTo,
        tags = tags,
    )
}
