@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.kotlin.outputs.EventIntegrationEventFilter
import com.pulumi.aws.appconfig.kotlin.outputs.EventIntegrationEventFilter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EventIntegration].
 */
@PulumiTagMarker
public class EventIntegrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventIntegrationArgs = EventIntegrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventIntegrationArgsBuilder.() -> Unit) {
        val builder = EventIntegrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventIntegration {
        val builtJavaResource = com.pulumi.aws.appconfig.EventIntegration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventIntegration(builtJavaResource)
    }
}

/**
 * Provides an Amazon AppIntegrations Event Integration resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appconfig.EventIntegration("example", {
 *     name: "example-name",
 *     description: "Example Description",
 *     eventbridgeBus: "default",
 *     eventFilter: {
 *         source: "aws.partner/examplepartner.com",
 *     },
 *     tags: {
 *         Name: "Example Event Integration",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appconfig.EventIntegration("example",
 *     name="example-name",
 *     description="Example Description",
 *     eventbridge_bus="default",
 *     event_filter={
 *         "source": "aws.partner/examplepartner.com",
 *     },
 *     tags={
 *         "Name": "Example Event Integration",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppConfig.EventIntegration("example", new()
 *     {
 *         Name = "example-name",
 *         Description = "Example Description",
 *         EventbridgeBus = "default",
 *         EventFilter = new Aws.AppConfig.Inputs.EventIntegrationEventFilterArgs
 *         {
 *             Source = "aws.partner/examplepartner.com",
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Event Integration" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appconfig"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfig.NewEventIntegration(ctx, "example", &appconfig.EventIntegrationArgs{
 * 			Name:           pulumi.String("example-name"),
 * 			Description:    pulumi.String("Example Description"),
 * 			EventbridgeBus: pulumi.String("default"),
 * 			EventFilter: &appconfig.EventIntegrationEventFilterArgs{
 * 				Source: pulumi.String("aws.partner/examplepartner.com"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Event Integration"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.EventIntegration;
 * import com.pulumi.aws.appconfig.EventIntegrationArgs;
 * import com.pulumi.aws.appconfig.inputs.EventIntegrationEventFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventIntegration("example", EventIntegrationArgs.builder()
 *             .name("example-name")
 *             .description("Example Description")
 *             .eventbridgeBus("default")
 *             .eventFilter(EventIntegrationEventFilterArgs.builder()
 *                 .source("aws.partner/examplepartner.com")
 *                 .build())
 *             .tags(Map.of("Name", "Example Event Integration"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appconfig:EventIntegration
 *     properties:
 *       name: example-name
 *       description: Example Description
 *       eventbridgeBus: default
 *       eventFilter:
 *         source: aws.partner/examplepartner.com
 *       tags:
 *         Name: Example Event Integration
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon AppIntegrations Event Integrations using the `name`. For example:
 * ```sh
 * $ pulumi import aws:appconfig/eventIntegration:EventIntegration example example-name
 * ```
 */
public class EventIntegration internal constructor(
    override val javaResource: com.pulumi.aws.appconfig.EventIntegration,
) : KotlinCustomResource(javaResource, EventIntegrationMapper) {
    /**
     * ARN of the Event Integration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the Event Integration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Block that defines the configuration information for the event filter. The Event Filter block is documented below.
     */
    public val eventFilter: Output<EventIntegrationEventFilter>
        get() = javaResource.eventFilter().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * EventBridge bus.
     */
    public val eventbridgeBus: Output<String>
        get() = javaResource.eventbridgeBus().applyValue({ args0 -> args0 })

    /**
     * Name of the Event Integration.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the Event Integration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object EventIntegrationMapper : ResourceMapper<EventIntegration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appconfig.EventIntegration::class == javaResource::class

    override fun map(javaResource: Resource): EventIntegration = EventIntegration(
        javaResource as
            com.pulumi.aws.appconfig.EventIntegration,
    )
}

/**
 * @see [EventIntegration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventIntegration].
 */
public suspend fun eventIntegration(
    name: String,
    block: suspend EventIntegrationResourceBuilder.() -> Unit,
): EventIntegration {
    val builder = EventIntegrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventIntegration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventIntegration(name: String): EventIntegration {
    val builder = EventIntegrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
