@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.kotlin.outputs.ExtensionActionPoint
import com.pulumi.aws.appconfig.kotlin.outputs.ExtensionParameter
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.appconfig.kotlin.outputs.ExtensionActionPoint.Companion.toKotlin as extensionActionPointToKotlin
import com.pulumi.aws.appconfig.kotlin.outputs.ExtensionParameter.Companion.toKotlin as extensionParameterToKotlin

/**
 * Builder for [Extension].
 */
@PulumiTagMarker
public class ExtensionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExtensionArgs = ExtensionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExtensionArgsBuilder.() -> Unit) {
        val builder = ExtensionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Extension {
        val builtJavaResource = com.pulumi.aws.appconfig.Extension(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Extension(builtJavaResource)
    }
}

/**
 * Provides an AppConfig Extension resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testTopic = new aws.sns.Topic("test", {name: "test"});
 * const test = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["appconfig&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const testRole = new aws.iam.Role("test", {
 *     name: "test",
 *     assumeRolePolicy: test.then(test => test.json),
 * });
 * const testExtension = new aws.appconfig.Extension("test", {
 *     name: "test",
 *     description: "test description",
 *     actionPoints: [{
 *         point: "ON_DEPLOYMENT_COMPLETE",
 *         actions: [{
 *             name: "test",
 *             roleArn: testRole.arn,
 *             uri: testTopic.arn,
 *         }],
 *     }],
 *     tags: {
 *         Type: "AppConfig Extension",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_topic = aws.sns.Topic("test", name="test")
 * test = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["appconfig&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * test_role = aws.iam.Role("test",
 *     name="test",
 *     assume_role_policy=test.json)
 * test_extension = aws.appconfig.Extension("test",
 *     name="test",
 *     description="test description",
 *     action_points=[{
 *         "point": "ON_DEPLOYMENT_COMPLETE",
 *         "actions": [{
 *             "name": "test",
 *             "role_arn": test_role.arn,
 *             "uri": test_topic.arn,
 *         }],
 *     }],
 *     tags={
 *         "Type": "AppConfig Extension",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testTopic = new Aws.Sns.Topic("test", new()
 *     {
 *         Name = "test",
 *     });
 *     var test = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "appconfig.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var testRole = new Aws.Iam.Role("test", new()
 *     {
 *         Name = "test",
 *         AssumeRolePolicy = test.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var testExtension = new Aws.AppConfig.Extension("test", new()
 *     {
 *         Name = "test",
 *         Description = "test description",
 *         ActionPoints = new[]
 *         {
 *             new Aws.AppConfig.Inputs.ExtensionActionPointArgs
 *             {
 *                 Point = "ON_DEPLOYMENT_COMPLETE",
 *                 Actions = new[]
 *                 {
 *                     new Aws.AppConfig.Inputs.ExtensionActionPointActionArgs
 *                     {
 *                         Name = "test",
 *                         RoleArn = testRole.Arn,
 *                         Uri = testTopic.Arn,
 *                     },
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Type", "AppConfig Extension" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appconfig"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testTopic, err := sns.NewTopic(ctx, "test", &sns.TopicArgs{
 * 			Name: pulumi.String("test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"appconfig.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testRole, err := iam.NewRole(ctx, "test", &iam.RoleArgs{
 * 			Name:             pulumi.String("test"),
 * 			AssumeRolePolicy: pulumi.String(test.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appconfig.NewExtension(ctx, "test", &appconfig.ExtensionArgs{
 * 			Name:        pulumi.String("test"),
 * 			Description: pulumi.String("test description"),
 * 			ActionPoints: appconfig.ExtensionActionPointArray{
 * 				&appconfig.ExtensionActionPointArgs{
 * 					Point: pulumi.String("ON_DEPLOYMENT_COMPLETE"),
 * 					Actions: appconfig.ExtensionActionPointActionArray{
 * 						&appconfig.ExtensionActionPointActionArgs{
 * 							Name:    pulumi.String("test"),
 * 							RoleArn: testRole.Arn,
 * 							Uri:     testTopic.Arn,
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Type": pulumi.String("AppConfig Extension"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.appconfig.Extension;
 * import com.pulumi.aws.appconfig.ExtensionArgs;
 * import com.pulumi.aws.appconfig.inputs.ExtensionActionPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTopic = new Topic("testTopic", TopicArgs.builder()
 *             .name("test")
 *             .build());
 *         final var test = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appconfig.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .name("test")
 *             .assumeRolePolicy(test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testExtension = new Extension("testExtension", ExtensionArgs.builder()
 *             .name("test")
 *             .description("test description")
 *             .actionPoints(ExtensionActionPointArgs.builder()
 *                 .point("ON_DEPLOYMENT_COMPLETE")
 *                 .actions(ExtensionActionPointActionArgs.builder()
 *                     .name("test")
 *                     .roleArn(testRole.arn())
 *                     .uri(testTopic.arn())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Type", "AppConfig Extension"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testTopic:
 *     type: aws:sns:Topic
 *     name: test
 *     properties:
 *       name: test
 *   testRole:
 *     type: aws:iam:Role
 *     name: test
 *     properties:
 *       name: test
 *       assumeRolePolicy: ${test.json}
 *   testExtension:
 *     type: aws:appconfig:Extension
 *     name: test
 *     properties:
 *       name: test
 *       description: test description
 *       actionPoints:
 *         - point: ON_DEPLOYMENT_COMPLETE
 *           actions:
 *             - name: test
 *               roleArn: ${testRole.arn}
 *               uri: ${testTopic.arn}
 *       tags:
 *         Type: AppConfig Extension
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - appconfig.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppConfig Extensions using their extension ID. For example:
 * ```sh
 * $ pulumi import aws:appconfig/extension:Extension example 71rxuzt
 * ```
 */
public class Extension internal constructor(
    override val javaResource: com.pulumi.aws.appconfig.Extension,
) : KotlinCustomResource(javaResource, ExtensionMapper) {
    /**
     * The action points defined in the extension. Detailed below.
     */
    public val actionPoints: Output<List<ExtensionActionPoint>>
        get() = javaResource.actionPoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    extensionActionPointToKotlin(args0)
                })
            })
        })

    /**
     * ARN of the AppConfig Extension.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Information about the extension.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * A name for the extension. Each extension name in your account must be unique. Extension versions use the same name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    public val parameters: Output<List<ExtensionParameter>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    extensionParameterToKotlin(args0)
                })
            })
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The version number for the extension.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object ExtensionMapper : ResourceMapper<Extension> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appconfig.Extension::class == javaResource::class

    override fun map(javaResource: Resource): Extension = Extension(
        javaResource as
            com.pulumi.aws.appconfig.Extension,
    )
}

/**
 * @see [Extension].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Extension].
 */
public suspend fun extension(name: String, block: suspend ExtensionResourceBuilder.() -> Unit): Extension {
    val builder = ExtensionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Extension].
 * @param name The _unique_ name of the resulting resource.
 */
public fun extension(name: String): Extension {
    val builder = ExtensionResourceBuilder()
    builder.name(name)
    return builder.build()
}
