@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.ExtensionArgs.builder
import com.pulumi.aws.appconfig.kotlin.inputs.ExtensionActionPointArgs
import com.pulumi.aws.appconfig.kotlin.inputs.ExtensionActionPointArgsBuilder
import com.pulumi.aws.appconfig.kotlin.inputs.ExtensionParameterArgs
import com.pulumi.aws.appconfig.kotlin.inputs.ExtensionParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppConfig Extension resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testTopic = new aws.sns.Topic("test", {name: "test"});
 * const test = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["appconfig&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const testRole = new aws.iam.Role("test", {
 *     name: "test",
 *     assumeRolePolicy: test.then(test => test.json),
 * });
 * const testExtension = new aws.appconfig.Extension("test", {
 *     name: "test",
 *     description: "test description",
 *     actionPoints: [{
 *         point: "ON_DEPLOYMENT_COMPLETE",
 *         actions: [{
 *             name: "test",
 *             roleArn: testRole.arn,
 *             uri: testTopic.arn,
 *         }],
 *     }],
 *     tags: {
 *         Type: "AppConfig Extension",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_topic = aws.sns.Topic("test", name="test")
 * test = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["appconfig&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * test_role = aws.iam.Role("test",
 *     name="test",
 *     assume_role_policy=test.json)
 * test_extension = aws.appconfig.Extension("test",
 *     name="test",
 *     description="test description",
 *     action_points=[{
 *         "point": "ON_DEPLOYMENT_COMPLETE",
 *         "actions": [{
 *             "name": "test",
 *             "role_arn": test_role.arn,
 *             "uri": test_topic.arn,
 *         }],
 *     }],
 *     tags={
 *         "Type": "AppConfig Extension",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testTopic = new Aws.Sns.Topic("test", new()
 *     {
 *         Name = "test",
 *     });
 *     var test = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "appconfig.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var testRole = new Aws.Iam.Role("test", new()
 *     {
 *         Name = "test",
 *         AssumeRolePolicy = test.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var testExtension = new Aws.AppConfig.Extension("test", new()
 *     {
 *         Name = "test",
 *         Description = "test description",
 *         ActionPoints = new[]
 *         {
 *             new Aws.AppConfig.Inputs.ExtensionActionPointArgs
 *             {
 *                 Point = "ON_DEPLOYMENT_COMPLETE",
 *                 Actions = new[]
 *                 {
 *                     new Aws.AppConfig.Inputs.ExtensionActionPointActionArgs
 *                     {
 *                         Name = "test",
 *                         RoleArn = testRole.Arn,
 *                         Uri = testTopic.Arn,
 *                     },
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Type", "AppConfig Extension" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appconfig"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		testTopic, err := sns.NewTopic(ctx, "test", &sns.TopicArgs{
 * 			Name: pulumi.String("test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"appconfig.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testRole, err := iam.NewRole(ctx, "test", &iam.RoleArgs{
 * 			Name:             pulumi.String("test"),
 * 			AssumeRolePolicy: pulumi.String(test.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appconfig.NewExtension(ctx, "test", &appconfig.ExtensionArgs{
 * 			Name:        pulumi.String("test"),
 * 			Description: pulumi.String("test description"),
 * 			ActionPoints: appconfig.ExtensionActionPointArray{
 * 				&appconfig.ExtensionActionPointArgs{
 * 					Point: pulumi.String("ON_DEPLOYMENT_COMPLETE"),
 * 					Actions: appconfig.ExtensionActionPointActionArray{
 * 						&appconfig.ExtensionActionPointActionArgs{
 * 							Name:    pulumi.String("test"),
 * 							RoleArn: testRole.Arn,
 * 							Uri:     testTopic.Arn,
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Type": pulumi.String("AppConfig Extension"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.appconfig.Extension;
 * import com.pulumi.aws.appconfig.ExtensionArgs;
 * import com.pulumi.aws.appconfig.inputs.ExtensionActionPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testTopic = new Topic("testTopic", TopicArgs.builder()
 *             .name("test")
 *             .build());
 *         final var test = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("appconfig.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testRole = new Role("testRole", RoleArgs.builder()
 *             .name("test")
 *             .assumeRolePolicy(test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testExtension = new Extension("testExtension", ExtensionArgs.builder()
 *             .name("test")
 *             .description("test description")
 *             .actionPoints(ExtensionActionPointArgs.builder()
 *                 .point("ON_DEPLOYMENT_COMPLETE")
 *                 .actions(ExtensionActionPointActionArgs.builder()
 *                     .name("test")
 *                     .roleArn(testRole.arn())
 *                     .uri(testTopic.arn())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Type", "AppConfig Extension"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testTopic:
 *     type: aws:sns:Topic
 *     name: test
 *     properties:
 *       name: test
 *   testRole:
 *     type: aws:iam:Role
 *     name: test
 *     properties:
 *       name: test
 *       assumeRolePolicy: ${test.json}
 *   testExtension:
 *     type: aws:appconfig:Extension
 *     name: test
 *     properties:
 *       name: test
 *       description: test description
 *       actionPoints:
 *         - point: ON_DEPLOYMENT_COMPLETE
 *           actions:
 *             - name: test
 *               roleArn: ${testRole.arn}
 *               uri: ${testTopic.arn}
 *       tags:
 *         Type: AppConfig Extension
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - appconfig.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppConfig Extensions using their extension ID. For example:
 * ```sh
 * $ pulumi import aws:appconfig/extension:Extension example 71rxuzt
 * ```
 * @property actionPoints The action points defined in the extension. Detailed below.
 * @property description Information about the extension.
 * @property name A name for the extension. Each extension name in your account must be unique. Extension versions use the same name.
 * @property parameters The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ExtensionArgs(
    public val actionPoints: Output<List<ExtensionActionPointArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<List<ExtensionParameterArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.ExtensionArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.ExtensionArgs =
        com.pulumi.aws.appconfig.ExtensionArgs.builder()
            .actionPoints(
                actionPoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ExtensionArgs].
 */
@PulumiTagMarker
public class ExtensionArgsBuilder internal constructor() {
    private var actionPoints: Output<List<ExtensionActionPointArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<List<ExtensionParameterArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The action points defined in the extension. Detailed below.
     */
    @JvmName("hcdtmlcamxanwluh")
    public suspend fun actionPoints(`value`: Output<List<ExtensionActionPointArgs>>) {
        this.actionPoints = value
    }

    @JvmName("fddsaffwkyffgnjp")
    public suspend fun actionPoints(vararg values: Output<ExtensionActionPointArgs>) {
        this.actionPoints = Output.all(values.asList())
    }

    /**
     * @param values The action points defined in the extension. Detailed below.
     */
    @JvmName("bqfpehloyrugdmgq")
    public suspend fun actionPoints(values: List<Output<ExtensionActionPointArgs>>) {
        this.actionPoints = Output.all(values)
    }

    /**
     * @param value Information about the extension.
     */
    @JvmName("urmngheuhdubydai")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A name for the extension. Each extension name in your account must be unique. Extension versions use the same name.
     */
    @JvmName("tstckcmdpjsgxgeq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("vutbtxjrltruoqpu")
    public suspend fun parameters(`value`: Output<List<ExtensionParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("vpheidtyheiifayu")
    public suspend fun parameters(vararg values: Output<ExtensionParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("ljhshpostpimprix")
    public suspend fun parameters(values: List<Output<ExtensionParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jcqtrfstuqlclebr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The action points defined in the extension. Detailed below.
     */
    @JvmName("yeymxjmgpxagxjid")
    public suspend fun actionPoints(`value`: List<ExtensionActionPointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionPoints = mapped
    }

    /**
     * @param argument The action points defined in the extension. Detailed below.
     */
    @JvmName("sylnngddllwuqlrc")
    public suspend fun actionPoints(argument: List<suspend ExtensionActionPointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExtensionActionPointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actionPoints = mapped
    }

    /**
     * @param argument The action points defined in the extension. Detailed below.
     */
    @JvmName("lwkogvjvmexvmrlo")
    public suspend fun actionPoints(vararg argument: suspend ExtensionActionPointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExtensionActionPointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actionPoints = mapped
    }

    /**
     * @param argument The action points defined in the extension. Detailed below.
     */
    @JvmName("amlqxvoxytvnumxm")
    public suspend fun actionPoints(argument: suspend ExtensionActionPointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExtensionActionPointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.actionPoints = mapped
    }

    /**
     * @param values The action points defined in the extension. Detailed below.
     */
    @JvmName("plsbddqyjmurmvmu")
    public suspend fun actionPoints(vararg values: ExtensionActionPointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionPoints = mapped
    }

    /**
     * @param value Information about the extension.
     */
    @JvmName("ncqknvmfsqbxfqtc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A name for the extension. Each extension name in your account must be unique. Extension versions use the same name.
     */
    @JvmName("mnoxqvlwabskyuof")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("vxjkvaqfnxmphyra")
    public suspend fun parameters(`value`: List<ExtensionParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("tivvmsunsownigax")
    public suspend fun parameters(argument: List<suspend ExtensionParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExtensionParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("dqvhtmvyyvhflumq")
    public suspend fun parameters(vararg argument: suspend ExtensionParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExtensionParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("apajouhwduefwtie")
    public suspend fun parameters(argument: suspend ExtensionParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExtensionParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters accepted by the extension. You specify parameter values when you associate the extension to an AppConfig resource by using the CreateExtensionAssociation API action. For Lambda extension actions, these parameters are included in the Lambda request object. Detailed below.
     */
    @JvmName("cmxetwusjswfbgvt")
    public suspend fun parameters(vararg values: ExtensionParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("huaomygojipkvinl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nblhdhlgceindxkr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ExtensionArgs = ExtensionArgs(
        actionPoints = actionPoints,
        description = description,
        name = name,
        parameters = parameters,
        tags = tags,
    )
}
