@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin

import com.pulumi.aws.appconfig.HostedConfigurationVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppConfig Hosted Configuration Version resource.
 * ## Example Usage
 * ### Freeform
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appconfig.HostedConfigurationVersion("example", {
 *     applicationId: exampleAwsAppconfigApplication.id,
 *     configurationProfileId: exampleAwsAppconfigConfigurationProfile.configurationProfileId,
 *     description: "Example Freeform Hosted Configuration Version",
 *     contentType: "application/json",
 *     content: JSON.stringify({
 *         foo: "bar",
 *         fruit: [
 *             "apple",
 *             "pear",
 *             "orange",
 *         ],
 *         isThingEnabled: true,
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.appconfig.HostedConfigurationVersion("example",
 *     application_id=example_aws_appconfig_application["id"],
 *     configuration_profile_id=example_aws_appconfig_configuration_profile["configurationProfileId"],
 *     description="Example Freeform Hosted Configuration Version",
 *     content_type="application/json",
 *     content=json.dumps({
 *         "foo": "bar",
 *         "fruit": [
 *             "apple",
 *             "pear",
 *             "orange",
 *         ],
 *         "isThingEnabled": True,
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppConfig.HostedConfigurationVersion("example", new()
 *     {
 *         ApplicationId = exampleAwsAppconfigApplication.Id,
 *         ConfigurationProfileId = exampleAwsAppconfigConfigurationProfile.ConfigurationProfileId,
 *         Description = "Example Freeform Hosted Configuration Version",
 *         ContentType = "application/json",
 *         Content = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["foo"] = "bar",
 *             ["fruit"] = new[]
 *             {
 *                 "apple",
 *                 "pear",
 *                 "orange",
 *             },
 *             ["isThingEnabled"] = true,
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appconfig"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"foo": "bar",
 * 			"fruit": []string{
 * 				"apple",
 * 				"pear",
 * 				"orange",
 * 			},
 * 			"isThingEnabled": true,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = appconfig.NewHostedConfigurationVersion(ctx, "example", &appconfig.HostedConfigurationVersionArgs{
 * 			ApplicationId:          pulumi.Any(exampleAwsAppconfigApplication.Id),
 * 			ConfigurationProfileId: pulumi.Any(exampleAwsAppconfigConfigurationProfile.ConfigurationProfileId),
 * 			Description:            pulumi.String("Example Freeform Hosted Configuration Version"),
 * 			ContentType:            pulumi.String("application/json"),
 * 			Content:                pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersion;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HostedConfigurationVersion("example", HostedConfigurationVersionArgs.builder()
 *             .applicationId(exampleAwsAppconfigApplication.id())
 *             .configurationProfileId(exampleAwsAppconfigConfigurationProfile.configurationProfileId())
 *             .description("Example Freeform Hosted Configuration Version")
 *             .contentType("application/json")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("foo", "bar"),
 *                     jsonProperty("fruit", jsonArray(
 *                         "apple",
 *                         "pear",
 *                         "orange"
 *                     )),
 *                     jsonProperty("isThingEnabled", true)
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appconfig:HostedConfigurationVersion
 *     properties:
 *       applicationId: ${exampleAwsAppconfigApplication.id}
 *       configurationProfileId: ${exampleAwsAppconfigConfigurationProfile.configurationProfileId}
 *       description: Example Freeform Hosted Configuration Version
 *       contentType: application/json
 *       content:
 *         fn::toJSON:
 *           foo: bar
 *           fruit:
 *             - apple
 *             - pear
 *             - orange
 *           isThingEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Feature Flags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appconfig.HostedConfigurationVersion("example", {
 *     applicationId: exampleAwsAppconfigApplication.id,
 *     configurationProfileId: exampleAwsAppconfigConfigurationProfile.configurationProfileId,
 *     description: "Example Feature Flag Configuration Version",
 *     contentType: "application/json",
 *     content: JSON.stringify({
 *         flags: {
 *             foo: {
 *                 name: "foo",
 *                 _deprecation: {
 *                     status: "planned",
 *                 },
 *             },
 *             bar: {
 *                 name: "bar",
 *                 attributes: {
 *                     someAttribute: {
 *                         constraints: {
 *                             type: "string",
 *                             required: true,
 *                         },
 *                     },
 *                     someOtherAttribute: {
 *                         constraints: {
 *                             type: "number",
 *                             required: true,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         values: {
 *             foo: {
 *                 enabled: "true",
 *             },
 *             bar: {
 *                 enabled: "true",
 *                 someAttribute: "Hello World",
 *                 someOtherAttribute: 123,
 *             },
 *         },
 *         version: "1",
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.appconfig.HostedConfigurationVersion("example",
 *     application_id=example_aws_appconfig_application["id"],
 *     configuration_profile_id=example_aws_appconfig_configuration_profile["configurationProfileId"],
 *     description="Example Feature Flag Configuration Version",
 *     content_type="application/json",
 *     content=json.dumps({
 *         "flags": {
 *             "foo": {
 *                 "name": "foo",
 *                 "_deprecation": {
 *                     "status": "planned",
 *                 },
 *             },
 *             "bar": {
 *                 "name": "bar",
 *                 "attributes": {
 *                     "someAttribute": {
 *                         "constraints": {
 *                             "type": "string",
 *                             "required": True,
 *                         },
 *                     },
 *                     "someOtherAttribute": {
 *                         "constraints": {
 *                             "type": "number",
 *                             "required": True,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         "values": {
 *             "foo": {
 *                 "enabled": "true",
 *             },
 *             "bar": {
 *                 "enabled": "true",
 *                 "someAttribute": "Hello World",
 *                 "someOtherAttribute": 123,
 *             },
 *         },
 *         "version": "1",
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppConfig.HostedConfigurationVersion("example", new()
 *     {
 *         ApplicationId = exampleAwsAppconfigApplication.Id,
 *         ConfigurationProfileId = exampleAwsAppconfigConfigurationProfile.ConfigurationProfileId,
 *         Description = "Example Feature Flag Configuration Version",
 *         ContentType = "application/json",
 *         Content = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["flags"] = new Dictionary<string, object?>
 *             {
 *                 ["foo"] = new Dictionary<string, object?>
 *                 {
 *                     ["name"] = "foo",
 *                     ["_deprecation"] = new Dictionary<string, object?>
 *                     {
 *                         ["status"] = "planned",
 *                     },
 *                 },
 *                 ["bar"] = new Dictionary<string, object?>
 *                 {
 *                     ["name"] = "bar",
 *                     ["attributes"] = new Dictionary<string, object?>
 *                     {
 *                         ["someAttribute"] = new Dictionary<string, object?>
 *                         {
 *                             ["constraints"] = new Dictionary<string, object?>
 *                             {
 *                                 ["type"] = "string",
 *                                 ["required"] = true,
 *                             },
 *                         },
 *                         ["someOtherAttribute"] = new Dictionary<string, object?>
 *                         {
 *                             ["constraints"] = new Dictionary<string, object?>
 *                             {
 *                                 ["type"] = "number",
 *                                 ["required"] = true,
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             ["values"] = new Dictionary<string, object?>
 *             {
 *                 ["foo"] = new Dictionary<string, object?>
 *                 {
 *                     ["enabled"] = "true",
 *                 },
 *                 ["bar"] = new Dictionary<string, object?>
 *                 {
 *                     ["enabled"] = "true",
 *                     ["someAttribute"] = "Hello World",
 *                     ["someOtherAttribute"] = 123,
 *                 },
 *             },
 *             ["version"] = "1",
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appconfig"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"flags": map[string]interface{}{
 * 				"foo": map[string]interface{}{
 * 					"name": "foo",
 * 					"_deprecation": map[string]interface{}{
 * 						"status": "planned",
 * 					},
 * 				},
 * 				"bar": map[string]interface{}{
 * 					"name": "bar",
 * 					"attributes": map[string]interface{}{
 * 						"someAttribute": map[string]interface{}{
 * 							"constraints": map[string]interface{}{
 * 								"type":     "string",
 * 								"required": true,
 * 							},
 * 						},
 * 						"someOtherAttribute": map[string]interface{}{
 * 							"constraints": map[string]interface{}{
 * 								"type":     "number",
 * 								"required": true,
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			"values": map[string]interface{}{
 * 				"foo": map[string]interface{}{
 * 					"enabled": "true",
 * 				},
 * 				"bar": map[string]interface{}{
 * 					"enabled":            "true",
 * 					"someAttribute":      "Hello World",
 * 					"someOtherAttribute": 123,
 * 				},
 * 			},
 * 			"version": "1",
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = appconfig.NewHostedConfigurationVersion(ctx, "example", &appconfig.HostedConfigurationVersionArgs{
 * 			ApplicationId:          pulumi.Any(exampleAwsAppconfigApplication.Id),
 * 			ConfigurationProfileId: pulumi.Any(exampleAwsAppconfigConfigurationProfile.ConfigurationProfileId),
 * 			Description:            pulumi.String("Example Feature Flag Configuration Version"),
 * 			ContentType:            pulumi.String("application/json"),
 * 			Content:                pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersion;
 * import com.pulumi.aws.appconfig.HostedConfigurationVersionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HostedConfigurationVersion("example", HostedConfigurationVersionArgs.builder()
 *             .applicationId(exampleAwsAppconfigApplication.id())
 *             .configurationProfileId(exampleAwsAppconfigConfigurationProfile.configurationProfileId())
 *             .description("Example Feature Flag Configuration Version")
 *             .contentType("application/json")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("flags", jsonObject(
 *                         jsonProperty("foo", jsonObject(
 *                             jsonProperty("name", "foo"),
 *                             jsonProperty("_deprecation", jsonObject(
 *                                 jsonProperty("status", "planned")
 *                             ))
 *                         )),
 *                         jsonProperty("bar", jsonObject(
 *                             jsonProperty("name", "bar"),
 *                             jsonProperty("attributes", jsonObject(
 *                                 jsonProperty("someAttribute", jsonObject(
 *                                     jsonProperty("constraints", jsonObject(
 *                                         jsonProperty("type", "string"),
 *                                         jsonProperty("required", true)
 *                                     ))
 *                                 )),
 *                                 jsonProperty("someOtherAttribute", jsonObject(
 *                                     jsonProperty("constraints", jsonObject(
 *                                         jsonProperty("type", "number"),
 *                                         jsonProperty("required", true)
 *                                     ))
 *                                 ))
 *                             ))
 *                         ))
 *                     )),
 *                     jsonProperty("values", jsonObject(
 *                         jsonProperty("foo", jsonObject(
 *                             jsonProperty("enabled", "true")
 *                         )),
 *                         jsonProperty("bar", jsonObject(
 *                             jsonProperty("enabled", "true"),
 *                             jsonProperty("someAttribute", "Hello World"),
 *                             jsonProperty("someOtherAttribute", 123)
 *                         ))
 *                     )),
 *                     jsonProperty("version", "1")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appconfig:HostedConfigurationVersion
 *     properties:
 *       applicationId: ${exampleAwsAppconfigApplication.id}
 *       configurationProfileId: ${exampleAwsAppconfigConfigurationProfile.configurationProfileId}
 *       description: Example Feature Flag Configuration Version
 *       contentType: application/json
 *       content:
 *         fn::toJSON:
 *           flags:
 *             foo:
 *               name: foo
 *               _deprecation:
 *                 status: planned
 *             bar:
 *               name: bar
 *               attributes:
 *                 someAttribute:
 *                   constraints:
 *                     type: string
 *                     required: true
 *                 someOtherAttribute:
 *                   constraints:
 *                     type: number
 *                     required: true
 *           values:
 *             foo:
 *               enabled: 'true'
 *             bar:
 *               enabled: 'true'
 *               someAttribute: Hello World
 *               someOtherAttribute: 123
 *           version: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppConfig Hosted Configuration Versions using the application ID, configuration profile ID, and version number separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:appconfig/hostedConfigurationVersion:HostedConfigurationVersion example 71abcde/11xxxxx/2
 * ```
 * @property applicationId Application ID.
 * @property configurationProfileId Configuration profile ID.
 * @property content Content of the configuration or the configuration data.
 * @property contentType Standard MIME type describing the format of the configuration content. For more information, see [Content-Type](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
 * @property description Description of the configuration.
 */
public data class HostedConfigurationVersionArgs(
    public val applicationId: Output<String>? = null,
    public val configurationProfileId: Output<String>? = null,
    public val content: Output<String>? = null,
    public val contentType: Output<String>? = null,
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.HostedConfigurationVersionArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.HostedConfigurationVersionArgs =
        com.pulumi.aws.appconfig.HostedConfigurationVersionArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .configurationProfileId(configurationProfileId?.applyValue({ args0 -> args0 }))
            .content(content?.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostedConfigurationVersionArgs].
 */
@PulumiTagMarker
public class HostedConfigurationVersionArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var configurationProfileId: Output<String>? = null

    private var content: Output<String>? = null

    private var contentType: Output<String>? = null

    private var description: Output<String>? = null

    /**
     * @param value Application ID.
     */
    @JvmName("lftalxvcteopfxjg")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Configuration profile ID.
     */
    @JvmName("hnyelutvtnlvgmbj")
    public suspend fun configurationProfileId(`value`: Output<String>) {
        this.configurationProfileId = value
    }

    /**
     * @param value Content of the configuration or the configuration data.
     */
    @JvmName("xxynvhghoduwpcnm")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Standard MIME type describing the format of the configuration content. For more information, see [Content-Type](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
     */
    @JvmName("bthupgveamivaore")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Description of the configuration.
     */
    @JvmName("tbxgsfkhdogdhjdw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Application ID.
     */
    @JvmName("tccrpbisjsfhwtau")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Configuration profile ID.
     */
    @JvmName("tltawnqfiljkxovd")
    public suspend fun configurationProfileId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProfileId = mapped
    }

    /**
     * @param value Content of the configuration or the configuration data.
     */
    @JvmName("hlrskmknhwsegwpn")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Standard MIME type describing the format of the configuration content. For more information, see [Content-Type](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
     */
    @JvmName("gppusfobuxjdrknh")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Description of the configuration.
     */
    @JvmName("vtcbvymdchqjrdpv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): HostedConfigurationVersionArgs = HostedConfigurationVersionArgs(
        applicationId = applicationId,
        configurationProfileId = configurationProfileId,
        content = content,
        contentType = contentType,
        description = description,
    )
}
