@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.inputs

import com.pulumi.aws.appconfig.inputs.EnvironmentMonitorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alarmArn ARN of the Amazon CloudWatch alarm.
 * @property alarmRoleArn ARN of an IAM role for AWS AppConfig to monitor `alarm_arn`.
 */
public data class EnvironmentMonitorArgs(
    public val alarmArn: Output<String>,
    public val alarmRoleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.inputs.EnvironmentMonitorArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.inputs.EnvironmentMonitorArgs =
        com.pulumi.aws.appconfig.inputs.EnvironmentMonitorArgs.builder()
            .alarmArn(alarmArn.applyValue({ args0 -> args0 }))
            .alarmRoleArn(alarmRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentMonitorArgs].
 */
@PulumiTagMarker
public class EnvironmentMonitorArgsBuilder internal constructor() {
    private var alarmArn: Output<String>? = null

    private var alarmRoleArn: Output<String>? = null

    /**
     * @param value ARN of the Amazon CloudWatch alarm.
     */
    @JvmName("patmhjcqugdoslhy")
    public suspend fun alarmArn(`value`: Output<String>) {
        this.alarmArn = value
    }

    /**
     * @param value ARN of an IAM role for AWS AppConfig to monitor `alarm_arn`.
     */
    @JvmName("ngrapvrctkkwdsaq")
    public suspend fun alarmRoleArn(`value`: Output<String>) {
        this.alarmRoleArn = value
    }

    /**
     * @param value ARN of the Amazon CloudWatch alarm.
     */
    @JvmName("gdyfrrssfqrsihab")
    public suspend fun alarmArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarmArn = mapped
    }

    /**
     * @param value ARN of an IAM role for AWS AppConfig to monitor `alarm_arn`.
     */
    @JvmName("adxgjfdxjvhoijtt")
    public suspend fun alarmRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarmRoleArn = mapped
    }

    internal fun build(): EnvironmentMonitorArgs = EnvironmentMonitorArgs(
        alarmArn = alarmArn ?: throw PulumiNullFieldException("alarmArn"),
        alarmRoleArn = alarmRoleArn,
    )
}
