@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.inputs

import com.pulumi.aws.appconfig.inputs.GetConfigurationProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConfigurationProfile.
 * @property applicationId ID of the AppConfig application to which this configuration profile belongs.
 * @property configurationProfileId ID of the Configuration Profile.
 * @property tags Map of tags for the resource.
 */
public data class GetConfigurationProfilePlainArgs(
    public val applicationId: String,
    public val configurationProfileId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.inputs.GetConfigurationProfilePlainArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.inputs.GetConfigurationProfilePlainArgs =
        com.pulumi.aws.appconfig.inputs.GetConfigurationProfilePlainArgs.builder()
            .applicationId(applicationId.let({ args0 -> args0 }))
            .configurationProfileId(configurationProfileId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetConfigurationProfilePlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationProfilePlainArgsBuilder internal constructor() {
    private var applicationId: String? = null

    private var configurationProfileId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the AppConfig application to which this configuration profile belongs.
     */
    @JvmName("jherelhrxlcssvis")
    public suspend fun applicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationId = mapped
    }

    /**
     * @param value ID of the Configuration Profile.
     */
    @JvmName("qkfoliqlmedorulh")
    public suspend fun configurationProfileId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationProfileId = mapped
    }

    /**
     * @param value Map of tags for the resource.
     */
    @JvmName("rfxdytlcrcdfbaux")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags for the resource.
     */
    @JvmName("hihjxiweoowrenlt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetConfigurationProfilePlainArgs = GetConfigurationProfilePlainArgs(
        applicationId = applicationId ?: throw PulumiNullFieldException("applicationId"),
        configurationProfileId = configurationProfileId ?: throw
            PulumiNullFieldException("configurationProfileId"),
        tags = tags,
    )
}
