@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.inputs

import com.pulumi.aws.appconfig.inputs.GetEnvironmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEnvironment.
 * @property applicationId ID of the AppConfig Application to which this Environment belongs.
 * @property environmentId ID of the AppConfig Environment.
 * @property tags Map of tags for the resource.
 */
public data class GetEnvironmentPlainArgs(
    public val applicationId: String,
    public val environmentId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appconfig.inputs.GetEnvironmentPlainArgs> {
    override fun toJava(): com.pulumi.aws.appconfig.inputs.GetEnvironmentPlainArgs =
        com.pulumi.aws.appconfig.inputs.GetEnvironmentPlainArgs.builder()
            .applicationId(applicationId.let({ args0 -> args0 }))
            .environmentId(environmentId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetEnvironmentPlainArgs].
 */
@PulumiTagMarker
public class GetEnvironmentPlainArgsBuilder internal constructor() {
    private var applicationId: String? = null

    private var environmentId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the AppConfig Application to which this Environment belongs.
     */
    @JvmName("ilpealxhjrdjovlj")
    public suspend fun applicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationId = mapped
    }

    /**
     * @param value ID of the AppConfig Environment.
     */
    @JvmName("qqmolqapvavvigqn")
    public suspend fun environmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentId = mapped
    }

    /**
     * @param value Map of tags for the resource.
     */
    @JvmName("yktrrnkeftnutbbu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags for the resource.
     */
    @JvmName("vyarkrdxnrdtxpfn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetEnvironmentPlainArgs = GetEnvironmentPlainArgs(
        applicationId = applicationId ?: throw PulumiNullFieldException("applicationId"),
        environmentId = environmentId ?: throw PulumiNullFieldException("environmentId"),
        tags = tags,
    )
}
