@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actions An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
 * @property point The point at which to perform the defined actions. Valid points are `PRE_CREATE_HOSTED_CONFIGURATION_VERSION`, `PRE_START_DEPLOYMENT`, `ON_DEPLOYMENT_START`, `ON_DEPLOYMENT_STEP`, `ON_DEPLOYMENT_BAKING`, `ON_DEPLOYMENT_COMPLETE`, `ON_DEPLOYMENT_ROLLED_BACK`.
 */
public data class ExtensionActionPoint(
    public val actions: List<ExtensionActionPointAction>,
    public val point: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appconfig.outputs.ExtensionActionPoint): ExtensionActionPoint = ExtensionActionPoint(
            actions = javaType.actions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appconfig.kotlin.outputs.ExtensionActionPointAction.Companion.toKotlin(args0)
                })
            }),
            point = javaType.point(),
        )
    }
}
