@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Information about the parameter.
 * @property name The parameter name.
 * @property required Determines if a parameter value must be specified in the extension association.
 */
public data class ExtensionParameter(
    public val description: String? = null,
    public val name: String,
    public val required: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appconfig.outputs.ExtensionParameter): ExtensionParameter = ExtensionParameter(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            required = javaType.required().map({ args0 -> args0 }).orElse(null),
        )
    }
}
