@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEnvironment.
 * @property applicationId
 * @property arn ARN of the environment.
 * @property description Name of the environment.
 * @property environmentId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property monitors Set of Amazon CloudWatch alarms to monitor during the deployment process.
 * @property name Name of the environment.
 * @property state State of the environment. Possible values are `READY_FOR_DEPLOYMENT`, `DEPLOYING`, `ROLLING_BACK`
 * or `ROLLED_BACK`.
 * @property tags Map of tags for the resource.
 */
public data class GetEnvironmentResult(
    public val applicationId: String,
    public val arn: String,
    public val description: String,
    public val environmentId: String,
    public val id: String,
    public val monitors: List<GetEnvironmentMonitor>,
    public val name: String,
    public val state: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appconfig.outputs.GetEnvironmentResult): GetEnvironmentResult = GetEnvironmentResult(
            applicationId = javaType.applicationId(),
            arn = javaType.arn(),
            description = javaType.description(),
            environmentId = javaType.environmentId(),
            id = javaType.id(),
            monitors = javaType.monitors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appconfig.kotlin.outputs.GetEnvironmentMonitor.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
