@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appconfig.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEnvironments.
 * @property applicationId
 * @property environmentIds Set of Environment IDs associated with this AppConfig Application.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetEnvironmentsResult(
    public val applicationId: String,
    public val environmentIds: List<String>,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appconfig.outputs.GetEnvironmentsResult): GetEnvironmentsResult = GetEnvironmentsResult(
            applicationId = javaType.applicationId(),
            environmentIds = javaType.environmentIds().map({ args0 -> args0 }),
            id = javaType.id(),
        )
    }
}
