@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin

import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationCredential
import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationTenant
import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationCredential.Companion.toKotlin as appAuthorizationCredentialToKotlin
import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationTenant.Companion.toKotlin as appAuthorizationTenantToKotlin
import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationTimeouts.Companion.toKotlin as appAuthorizationTimeoutsToKotlin

/**
 * Builder for [AppAuthorization].
 */
@PulumiTagMarker
public class AppAuthorizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppAuthorizationArgs = AppAuthorizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppAuthorizationArgsBuilder.() -> Unit) {
        val builder = AppAuthorizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppAuthorization {
        val builtJavaResource = com.pulumi.aws.appfabric.AppAuthorization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AppAuthorization(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS AppFabric App Authorization.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appfabric.AppAuthorization("example", {
 *     app: "TERRAFORMCLOUD",
 *     appBundleArn: arn,
 *     authType: "apiKey",
 *     credential: {
 *         apiKeyCredentials: [{
 *             apiKey: "exampleapikeytoken",
 *         }],
 *     },
 *     tenants: [{
 *         tenantDisplayName: "example",
 *         tenantIdentifier: "example",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appfabric.AppAuthorization("example",
 *     app="TERRAFORMCLOUD",
 *     app_bundle_arn=arn,
 *     auth_type="apiKey",
 *     credential={
 *         "api_key_credentials": [{
 *             "api_key": "exampleapikeytoken",
 *         }],
 *     },
 *     tenants=[{
 *         "tenant_display_name": "example",
 *         "tenant_identifier": "example",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppFabric.AppAuthorization("example", new()
 *     {
 *         App = "TERRAFORMCLOUD",
 *         AppBundleArn = arn,
 *         AuthType = "apiKey",
 *         Credential = new Aws.AppFabric.Inputs.AppAuthorizationCredentialArgs
 *         {
 *             ApiKeyCredentials = new[]
 *             {
 *                 new Aws.AppFabric.Inputs.AppAuthorizationCredentialApiKeyCredentialArgs
 *                 {
 *                     ApiKey = "exampleapikeytoken",
 *                 },
 *             },
 *         },
 *         Tenants = new[]
 *         {
 *             new Aws.AppFabric.Inputs.AppAuthorizationTenantArgs
 *             {
 *                 TenantDisplayName = "example",
 *                 TenantIdentifier = "example",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appfabric"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appfabric.NewAppAuthorization(ctx, "example", &appfabric.AppAuthorizationArgs{
 * 			App:          pulumi.String("TERRAFORMCLOUD"),
 * 			AppBundleArn: pulumi.Any(arn),
 * 			AuthType:     pulumi.String("apiKey"),
 * 			Credential: &appfabric.AppAuthorizationCredentialArgs{
 * 				ApiKeyCredentials: appfabric.AppAuthorizationCredentialApiKeyCredentialArray{
 * 					&appfabric.AppAuthorizationCredentialApiKeyCredentialArgs{
 * 						ApiKey: pulumi.String("exampleapikeytoken"),
 * 					},
 * 				},
 * 			},
 * 			Tenants: appfabric.AppAuthorizationTenantArray{
 * 				&appfabric.AppAuthorizationTenantArgs{
 * 					TenantDisplayName: pulumi.String("example"),
 * 					TenantIdentifier:  pulumi.String("example"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appfabric.AppAuthorization;
 * import com.pulumi.aws.appfabric.AppAuthorizationArgs;
 * import com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialArgs;
 * import com.pulumi.aws.appfabric.inputs.AppAuthorizationTenantArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppAuthorization("example", AppAuthorizationArgs.builder()
 *             .app("TERRAFORMCLOUD")
 *             .appBundleArn(arn)
 *             .authType("apiKey")
 *             .credential(AppAuthorizationCredentialArgs.builder()
 *                 .apiKeyCredentials(AppAuthorizationCredentialApiKeyCredentialArgs.builder()
 *                     .apiKey("exampleapikeytoken")
 *                     .build())
 *                 .build())
 *             .tenants(AppAuthorizationTenantArgs.builder()
 *                 .tenantDisplayName("example")
 *                 .tenantIdentifier("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appfabric:AppAuthorization
 *     properties:
 *       app: TERRAFORMCLOUD
 *       appBundleArn: ${arn}
 *       authType: apiKey
 *       credential:
 *         apiKeyCredentials:
 *           - apiKey: exampleapikeytoken
 *       tenants:
 *         - tenantDisplayName: example
 *           tenantIdentifier: example
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class AppAuthorization internal constructor(
    override val javaResource: com.pulumi.aws.appfabric.AppAuthorization,
) : KotlinCustomResource(javaResource, AppAuthorizationMapper) {
    /**
     * The name of the application for valid values see https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html.
     */
    public val app: Output<String>
        get() = javaResource.app().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    public val appBundleArn: Output<String>
        get() = javaResource.appBundleArn().applyValue({ args0 -> args0 })

    /**
     * ARN of the App Authorization. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The authorization type for the app authorization valid values are oauth2 and apiKey.
     */
    public val authType: Output<String>
        get() = javaResource.authType().applyValue({ args0 -> args0 })

    /**
     * The application URL for the OAuth flow.
     */
    public val authUrl: Output<String>
        get() = javaResource.authUrl().applyValue({ args0 -> args0 })

    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
     * Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
     */
    public val credential: Output<AppAuthorizationCredential>?
        get() = javaResource.credential().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    appAuthorizationCredentialToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The user persona of the app authorization.
     */
    public val persona: Output<String>
        get() = javaResource.persona().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Contains information about an application tenant, such as the application display name and identifier.
     */
    public val tenants: Output<List<AppAuthorizationTenant>>?
        get() = javaResource.tenants().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> appAuthorizationTenantToKotlin(args0) })
                })
            }).orElse(null)
        })

    public val timeouts: Output<AppAuthorizationTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    appAuthorizationTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object AppAuthorizationMapper : ResourceMapper<AppAuthorization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appfabric.AppAuthorization::class == javaResource::class

    override fun map(javaResource: Resource): AppAuthorization = AppAuthorization(
        javaResource as
            com.pulumi.aws.appfabric.AppAuthorization,
    )
}

/**
 * @see [AppAuthorization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppAuthorization].
 */
public suspend fun appAuthorization(
    name: String,
    block: suspend AppAuthorizationResourceBuilder.() -> Unit,
): AppAuthorization {
    val builder = AppAuthorizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppAuthorization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appAuthorization(name: String): AppAuthorization {
    val builder = AppAuthorizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
