@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin

import com.pulumi.aws.appfabric.AppAuthorizationArgs.builder
import com.pulumi.aws.appfabric.kotlin.inputs.AppAuthorizationCredentialArgs
import com.pulumi.aws.appfabric.kotlin.inputs.AppAuthorizationCredentialArgsBuilder
import com.pulumi.aws.appfabric.kotlin.inputs.AppAuthorizationTenantArgs
import com.pulumi.aws.appfabric.kotlin.inputs.AppAuthorizationTenantArgsBuilder
import com.pulumi.aws.appfabric.kotlin.inputs.AppAuthorizationTimeoutsArgs
import com.pulumi.aws.appfabric.kotlin.inputs.AppAuthorizationTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS AppFabric App Authorization.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appfabric.AppAuthorization("example", {
 *     app: "TERRAFORMCLOUD",
 *     appBundleArn: arn,
 *     authType: "apiKey",
 *     credential: {
 *         apiKeyCredentials: [{
 *             apiKey: "exampleapikeytoken",
 *         }],
 *     },
 *     tenants: [{
 *         tenantDisplayName: "example",
 *         tenantIdentifier: "example",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appfabric.AppAuthorization("example",
 *     app="TERRAFORMCLOUD",
 *     app_bundle_arn=arn,
 *     auth_type="apiKey",
 *     credential={
 *         "api_key_credentials": [{
 *             "api_key": "exampleapikeytoken",
 *         }],
 *     },
 *     tenants=[{
 *         "tenant_display_name": "example",
 *         "tenant_identifier": "example",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppFabric.AppAuthorization("example", new()
 *     {
 *         App = "TERRAFORMCLOUD",
 *         AppBundleArn = arn,
 *         AuthType = "apiKey",
 *         Credential = new Aws.AppFabric.Inputs.AppAuthorizationCredentialArgs
 *         {
 *             ApiKeyCredentials = new[]
 *             {
 *                 new Aws.AppFabric.Inputs.AppAuthorizationCredentialApiKeyCredentialArgs
 *                 {
 *                     ApiKey = "exampleapikeytoken",
 *                 },
 *             },
 *         },
 *         Tenants = new[]
 *         {
 *             new Aws.AppFabric.Inputs.AppAuthorizationTenantArgs
 *             {
 *                 TenantDisplayName = "example",
 *                 TenantIdentifier = "example",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appfabric"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appfabric.NewAppAuthorization(ctx, "example", &appfabric.AppAuthorizationArgs{
 * 			App:          pulumi.String("TERRAFORMCLOUD"),
 * 			AppBundleArn: pulumi.Any(arn),
 * 			AuthType:     pulumi.String("apiKey"),
 * 			Credential: &appfabric.AppAuthorizationCredentialArgs{
 * 				ApiKeyCredentials: appfabric.AppAuthorizationCredentialApiKeyCredentialArray{
 * 					&appfabric.AppAuthorizationCredentialApiKeyCredentialArgs{
 * 						ApiKey: pulumi.String("exampleapikeytoken"),
 * 					},
 * 				},
 * 			},
 * 			Tenants: appfabric.AppAuthorizationTenantArray{
 * 				&appfabric.AppAuthorizationTenantArgs{
 * 					TenantDisplayName: pulumi.String("example"),
 * 					TenantIdentifier:  pulumi.String("example"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appfabric.AppAuthorization;
 * import com.pulumi.aws.appfabric.AppAuthorizationArgs;
 * import com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialArgs;
 * import com.pulumi.aws.appfabric.inputs.AppAuthorizationTenantArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppAuthorization("example", AppAuthorizationArgs.builder()
 *             .app("TERRAFORMCLOUD")
 *             .appBundleArn(arn)
 *             .authType("apiKey")
 *             .credential(AppAuthorizationCredentialArgs.builder()
 *                 .apiKeyCredentials(AppAuthorizationCredentialApiKeyCredentialArgs.builder()
 *                     .apiKey("exampleapikeytoken")
 *                     .build())
 *                 .build())
 *             .tenants(AppAuthorizationTenantArgs.builder()
 *                 .tenantDisplayName("example")
 *                 .tenantIdentifier("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appfabric:AppAuthorization
 *     properties:
 *       app: TERRAFORMCLOUD
 *       appBundleArn: ${arn}
 *       authType: apiKey
 *       credential:
 *         apiKeyCredentials:
 *           - apiKey: exampleapikeytoken
 *       tenants:
 *         - tenantDisplayName: example
 *           tenantIdentifier: example
 * ```
 * <!--End PulumiCodeChooser -->
 * @property app The name of the application for valid values see https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html.
 * @property appBundleArn The Amazon Resource Name (ARN) of the app bundle to use for the request.
 * @property authType The authorization type for the app authorization valid values are oauth2 and apiKey.
 * @property credential Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
 * Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
 * @property tags
 * @property tenants Contains information about an application tenant, such as the application display name and identifier.
 * @property timeouts
 */
public data class AppAuthorizationArgs(
    public val app: Output<String>? = null,
    public val appBundleArn: Output<String>? = null,
    public val authType: Output<String>? = null,
    public val credential: Output<AppAuthorizationCredentialArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenants: Output<List<AppAuthorizationTenantArgs>>? = null,
    public val timeouts: Output<AppAuthorizationTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appfabric.AppAuthorizationArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.AppAuthorizationArgs =
        com.pulumi.aws.appfabric.AppAuthorizationArgs.builder()
            .app(app?.applyValue({ args0 -> args0 }))
            .appBundleArn(appBundleArn?.applyValue({ args0 -> args0 }))
            .authType(authType?.applyValue({ args0 -> args0 }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenants(
                tenants?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AppAuthorizationArgs].
 */
@PulumiTagMarker
public class AppAuthorizationArgsBuilder internal constructor() {
    private var app: Output<String>? = null

    private var appBundleArn: Output<String>? = null

    private var authType: Output<String>? = null

    private var credential: Output<AppAuthorizationCredentialArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenants: Output<List<AppAuthorizationTenantArgs>>? = null

    private var timeouts: Output<AppAuthorizationTimeoutsArgs>? = null

    /**
     * @param value The name of the application for valid values see https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html.
     */
    @JvmName("xrmrsnynbjlmqsor")
    public suspend fun app(`value`: Output<String>) {
        this.app = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    @JvmName("caegihtajdvuxpuu")
    public suspend fun appBundleArn(`value`: Output<String>) {
        this.appBundleArn = value
    }

    /**
     * @param value The authorization type for the app authorization valid values are oauth2 and apiKey.
     */
    @JvmName("pqyiwybwsbaigmon")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
     * Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
     */
    @JvmName("aanahtvxqeyhkoxu")
    public suspend fun credential(`value`: Output<AppAuthorizationCredentialArgs>) {
        this.credential = value
    }

    /**
     * @param value
     */
    @JvmName("ptrnttbxgfqslebx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Contains information about an application tenant, such as the application display name and identifier.
     */
    @JvmName("ekxhkvbebkerrjgw")
    public suspend fun tenants(`value`: Output<List<AppAuthorizationTenantArgs>>) {
        this.tenants = value
    }

    @JvmName("tqjiikyljkcxkkhd")
    public suspend fun tenants(vararg values: Output<AppAuthorizationTenantArgs>) {
        this.tenants = Output.all(values.asList())
    }

    /**
     * @param values Contains information about an application tenant, such as the application display name and identifier.
     */
    @JvmName("iikpcqufuomwblvl")
    public suspend fun tenants(values: List<Output<AppAuthorizationTenantArgs>>) {
        this.tenants = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("javujaxcgupxltwu")
    public suspend fun timeouts(`value`: Output<AppAuthorizationTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The name of the application for valid values see https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html.
     */
    @JvmName("wgsyocbdejuptlxi")
    public suspend fun app(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.app = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    @JvmName("lxprffyhjdrlofno")
    public suspend fun appBundleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appBundleArn = mapped
    }

    /**
     * @param value The authorization type for the app authorization valid values are oauth2 and apiKey.
     */
    @JvmName("vncejiypahdecjyr")
    public suspend fun authType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
     * Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
     */
    @JvmName("tkjpsuppfjuhctjl")
    public suspend fun credential(`value`: AppAuthorizationCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
     * Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
     */
    @JvmName("xhedhxnnbfwbgtqk")
    public suspend fun credential(argument: suspend AppAuthorizationCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = AppAuthorizationCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value
     */
    @JvmName("seetvctbljxtnedo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("uwhwuwabtxcsqumb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Contains information about an application tenant, such as the application display name and identifier.
     */
    @JvmName("krwloukrymoenrxr")
    public suspend fun tenants(`value`: List<AppAuthorizationTenantArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenants = mapped
    }

    /**
     * @param argument Contains information about an application tenant, such as the application display name and identifier.
     */
    @JvmName("fblicjtqfupcwblg")
    public suspend fun tenants(argument: List<suspend AppAuthorizationTenantArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AppAuthorizationTenantArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tenants = mapped
    }

    /**
     * @param argument Contains information about an application tenant, such as the application display name and identifier.
     */
    @JvmName("cdapubdxoejjogdu")
    public suspend fun tenants(vararg argument: suspend AppAuthorizationTenantArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AppAuthorizationTenantArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tenants = mapped
    }

    /**
     * @param argument Contains information about an application tenant, such as the application display name and identifier.
     */
    @JvmName("qqyqppelumuodach")
    public suspend fun tenants(argument: suspend AppAuthorizationTenantArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AppAuthorizationTenantArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tenants = mapped
    }

    /**
     * @param values Contains information about an application tenant, such as the application display name and identifier.
     */
    @JvmName("gomngvabrxepquio")
    public suspend fun tenants(vararg values: AppAuthorizationTenantArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenants = mapped
    }

    /**
     * @param value
     */
    @JvmName("wbalttdpcbqgbifm")
    public suspend fun timeouts(`value`: AppAuthorizationTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xvmgxfhqipsqntfv")
    public suspend fun timeouts(argument: suspend AppAuthorizationTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = AppAuthorizationTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): AppAuthorizationArgs = AppAuthorizationArgs(
        app = app,
        appBundleArn = appBundleArn,
        authType = authType,
        credential = credential,
        tags = tags,
        tenants = tenants,
        timeouts = timeouts,
    )
}
