@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin

import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationConnectionAuthRequest
import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationConnectionTenant
import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationConnectionTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationConnectionAuthRequest.Companion.toKotlin as appAuthorizationConnectionAuthRequestToKotlin
import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationConnectionTenant.Companion.toKotlin as appAuthorizationConnectionTenantToKotlin
import com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationConnectionTimeouts.Companion.toKotlin as appAuthorizationConnectionTimeoutsToKotlin

/**
 * Builder for [AppAuthorizationConnection].
 */
@PulumiTagMarker
public class AppAuthorizationConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppAuthorizationConnectionArgs = AppAuthorizationConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppAuthorizationConnectionArgsBuilder.() -> Unit) {
        val builder = AppAuthorizationConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppAuthorizationConnection {
        val builtJavaResource =
            com.pulumi.aws.appfabric.AppAuthorizationConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AppAuthorizationConnection(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS AppFabric App Authorization Connection.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appfabric.AppAuthorizationConnection("example", {
 *     appAuthorizationArn: test.arn,
 *     appBundleArn: arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appfabric.AppAuthorizationConnection("example",
 *     app_authorization_arn=test["arn"],
 *     app_bundle_arn=arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppFabric.AppAuthorizationConnection("example", new()
 *     {
 *         AppAuthorizationArn = test.Arn,
 *         AppBundleArn = arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appfabric"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appfabric.NewAppAuthorizationConnection(ctx, "example", &appfabric.AppAuthorizationConnectionArgs{
 * 			AppAuthorizationArn: pulumi.Any(test.Arn),
 * 			AppBundleArn:        pulumi.Any(arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appfabric.AppAuthorizationConnection;
 * import com.pulumi.aws.appfabric.AppAuthorizationConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppAuthorizationConnection("example", AppAuthorizationConnectionArgs.builder()
 *             .appAuthorizationArn(test.arn())
 *             .appBundleArn(arn)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appfabric:AppAuthorizationConnection
 *     properties:
 *       appAuthorizationArn: ${test.arn}
 *       appBundleArn: ${arn}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class AppAuthorizationConnection internal constructor(
    override val javaResource: com.pulumi.aws.appfabric.AppAuthorizationConnection,
) : KotlinCustomResource(javaResource, AppAuthorizationConnectionMapper) {
    /**
     * The name of the application.
     */
    public val app: Output<String>
        get() = javaResource.app().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
     */
    public val appAuthorizationArn: Output<String>
        get() = javaResource.appAuthorizationArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    public val appBundleArn: Output<String>
        get() = javaResource.appBundleArn().applyValue({ args0 -> args0 })

    /**
     * Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
     */
    public val authRequest: Output<AppAuthorizationConnectionAuthRequest>?
        get() = javaResource.authRequest().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    appAuthorizationConnectionAuthRequestToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Contains information about an application tenant, such as the application display name and identifier.
     */
    public val tenants: Output<List<AppAuthorizationConnectionTenant>>
        get() = javaResource.tenants().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    appAuthorizationConnectionTenantToKotlin(args0)
                })
            })
        })

    public val timeouts: Output<AppAuthorizationConnectionTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    appAuthorizationConnectionTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object AppAuthorizationConnectionMapper : ResourceMapper<AppAuthorizationConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appfabric.AppAuthorizationConnection::class == javaResource::class

    override fun map(javaResource: Resource): AppAuthorizationConnection =
        AppAuthorizationConnection(
            javaResource as
                com.pulumi.aws.appfabric.AppAuthorizationConnection,
        )
}

/**
 * @see [AppAuthorizationConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppAuthorizationConnection].
 */
public suspend fun appAuthorizationConnection(
    name: String,
    block: suspend AppAuthorizationConnectionResourceBuilder.() -> Unit,
): AppAuthorizationConnection {
    val builder = AppAuthorizationConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppAuthorizationConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appAuthorizationConnection(name: String): AppAuthorizationConnection {
    val builder = AppAuthorizationConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
