@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin

import com.pulumi.aws.appfabric.AppAuthorizationConnectionArgs.builder
import com.pulumi.aws.appfabric.kotlin.inputs.AppAuthorizationConnectionAuthRequestArgs
import com.pulumi.aws.appfabric.kotlin.inputs.AppAuthorizationConnectionAuthRequestArgsBuilder
import com.pulumi.aws.appfabric.kotlin.inputs.AppAuthorizationConnectionTimeoutsArgs
import com.pulumi.aws.appfabric.kotlin.inputs.AppAuthorizationConnectionTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS AppFabric App Authorization Connection.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appfabric.AppAuthorizationConnection("example", {
 *     appAuthorizationArn: test.arn,
 *     appBundleArn: arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appfabric.AppAuthorizationConnection("example",
 *     app_authorization_arn=test["arn"],
 *     app_bundle_arn=arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppFabric.AppAuthorizationConnection("example", new()
 *     {
 *         AppAuthorizationArn = test.Arn,
 *         AppBundleArn = arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appfabric"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appfabric.NewAppAuthorizationConnection(ctx, "example", &appfabric.AppAuthorizationConnectionArgs{
 * 			AppAuthorizationArn: pulumi.Any(test.Arn),
 * 			AppBundleArn:        pulumi.Any(arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appfabric.AppAuthorizationConnection;
 * import com.pulumi.aws.appfabric.AppAuthorizationConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppAuthorizationConnection("example", AppAuthorizationConnectionArgs.builder()
 *             .appAuthorizationArn(test.arn())
 *             .appBundleArn(arn)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appfabric:AppAuthorizationConnection
 *     properties:
 *       appAuthorizationArn: ${test.arn}
 *       appBundleArn: ${arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property appAuthorizationArn The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
 * @property appBundleArn The Amazon Resource Name (ARN) of the app bundle to use for the request.
 * @property authRequest Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
 * @property timeouts
 */
public data class AppAuthorizationConnectionArgs(
    public val appAuthorizationArn: Output<String>? = null,
    public val appBundleArn: Output<String>? = null,
    public val authRequest: Output<AppAuthorizationConnectionAuthRequestArgs>? = null,
    public val timeouts: Output<AppAuthorizationConnectionTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appfabric.AppAuthorizationConnectionArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.AppAuthorizationConnectionArgs =
        com.pulumi.aws.appfabric.AppAuthorizationConnectionArgs.builder()
            .appAuthorizationArn(appAuthorizationArn?.applyValue({ args0 -> args0 }))
            .appBundleArn(appBundleArn?.applyValue({ args0 -> args0 }))
            .authRequest(authRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AppAuthorizationConnectionArgs].
 */
@PulumiTagMarker
public class AppAuthorizationConnectionArgsBuilder internal constructor() {
    private var appAuthorizationArn: Output<String>? = null

    private var appBundleArn: Output<String>? = null

    private var authRequest: Output<AppAuthorizationConnectionAuthRequestArgs>? = null

    private var timeouts: Output<AppAuthorizationConnectionTimeoutsArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
     */
    @JvmName("ixvygcghledlhbnr")
    public suspend fun appAuthorizationArn(`value`: Output<String>) {
        this.appAuthorizationArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    @JvmName("qugitfasiljkxgbh")
    public suspend fun appBundleArn(`value`: Output<String>) {
        this.appBundleArn = value
    }

    /**
     * @param value Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
     */
    @JvmName("udclcmojattirpbs")
    public suspend fun authRequest(`value`: Output<AppAuthorizationConnectionAuthRequestArgs>) {
        this.authRequest = value
    }

    /**
     * @param value
     */
    @JvmName("oushquqhxcgafmyx")
    public suspend fun timeouts(`value`: Output<AppAuthorizationConnectionTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
     */
    @JvmName("sarigavwxtfmnell")
    public suspend fun appAuthorizationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appAuthorizationArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    @JvmName("acevooaiydhsympp")
    public suspend fun appBundleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appBundleArn = mapped
    }

    /**
     * @param value Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
     */
    @JvmName("lskyfntydxnlmamk")
    public suspend fun authRequest(`value`: AppAuthorizationConnectionAuthRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authRequest = mapped
    }

    /**
     * @param argument Contains OAuth2 authorization information.This is required if the app authorization for the request is configured with an OAuth2 (oauth2) authorization type.
     */
    @JvmName("kjxisesxutktxnlb")
    public suspend fun authRequest(argument: suspend AppAuthorizationConnectionAuthRequestArgsBuilder.() -> Unit) {
        val toBeMapped = AppAuthorizationConnectionAuthRequestArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authRequest = mapped
    }

    /**
     * @param value
     */
    @JvmName("ytppkuofmthlepbp")
    public suspend fun timeouts(`value`: AppAuthorizationConnectionTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dhvdobteaiwvhdvm")
    public suspend fun timeouts(argument: suspend AppAuthorizationConnectionTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = AppAuthorizationConnectionTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): AppAuthorizationConnectionArgs = AppAuthorizationConnectionArgs(
        appAuthorizationArn = appAuthorizationArn,
        appBundleArn = appBundleArn,
        authRequest = authRequest,
        timeouts = timeouts,
    )
}
