@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AppBundle].
 */
@PulumiTagMarker
public class AppBundleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppBundleArgs = AppBundleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppBundleArgsBuilder.() -> Unit) {
        val builder = AppBundleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppBundle {
        val builtJavaResource = com.pulumi.aws.appfabric.AppBundle(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AppBundle(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS AppFabric AppBundle.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appfabric.AppBundle("example", {
 *     customerManagedKeyArn: exampleAwmsKmsKey.arn,
 *     tags: {
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appfabric.AppBundle("example",
 *     customer_managed_key_arn=example_awms_kms_key["arn"],
 *     tags={
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppFabric.AppBundle("example", new()
 *     {
 *         CustomerManagedKeyArn = exampleAwmsKmsKey.Arn,
 *         Tags =
 *         {
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appfabric"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appfabric.NewAppBundle(ctx, "example", &appfabric.AppBundleArgs{
 * 			CustomerManagedKeyArn: pulumi.Any(exampleAwmsKmsKey.Arn),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appfabric.AppBundle;
 * import com.pulumi.aws.appfabric.AppBundleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppBundle("example", AppBundleArgs.builder()
 *             .customerManagedKeyArn(exampleAwmsKmsKey.arn())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appfabric:AppBundle
 *     properties:
 *       customerManagedKeyArn: ${exampleAwmsKmsKey.arn}
 *       tags:
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppFabric AppBundle using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:appfabric/appBundle:AppBundle example arn:aws:appfabric:[region]:[account]:appbundle/ee5587b4-5765-4288-a202-xxxxxxxxxx
 * ```
 */
public class AppBundle internal constructor(
    override val javaResource: com.pulumi.aws.appfabric.AppBundle,
) : KotlinCustomResource(javaResource, AppBundleMapper) {
    /**
     * ARN of the AppBundle.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the AWS Key Management Service (AWS KMS) key to use to encrypt the application data. If this is not specified, an AWS owned key is used for encryption.
     */
    public val customerManagedKeyArn: Output<String>?
        get() = javaResource.customerManagedKeyArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AppBundleMapper : ResourceMapper<AppBundle> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appfabric.AppBundle::class == javaResource::class

    override fun map(javaResource: Resource): AppBundle = AppBundle(
        javaResource as
            com.pulumi.aws.appfabric.AppBundle,
    )
}

/**
 * @see [AppBundle].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppBundle].
 */
public suspend fun appBundle(name: String, block: suspend AppBundleResourceBuilder.() -> Unit): AppBundle {
    val builder = AppBundleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppBundle].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appBundle(name: String): AppBundle {
    val builder = AppBundleResourceBuilder()
    builder.name(name)
    return builder.build()
}
