@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Ingestion].
 */
@PulumiTagMarker
public class IngestionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IngestionArgs = IngestionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IngestionArgsBuilder.() -> Unit) {
        val builder = IngestionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Ingestion {
        val builtJavaResource = com.pulumi.aws.appfabric.Ingestion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Ingestion(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS AppFabric Ingestion.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appfabric.Ingestion("example", {
 *     app: "OKTA",
 *     appBundleArn: exampleAwsAppfabricAppBundle.arn,
 *     tenantId: "example.okta.com",
 *     ingestionType: "auditLog",
 *     tags: {
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appfabric.Ingestion("example",
 *     app="OKTA",
 *     app_bundle_arn=example_aws_appfabric_app_bundle["arn"],
 *     tenant_id="example.okta.com",
 *     ingestion_type="auditLog",
 *     tags={
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppFabric.Ingestion("example", new()
 *     {
 *         App = "OKTA",
 *         AppBundleArn = exampleAwsAppfabricAppBundle.Arn,
 *         TenantId = "example.okta.com",
 *         IngestionType = "auditLog",
 *         Tags =
 *         {
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appfabric"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appfabric.NewIngestion(ctx, "example", &appfabric.IngestionArgs{
 * 			App:           pulumi.String("OKTA"),
 * 			AppBundleArn:  pulumi.Any(exampleAwsAppfabricAppBundle.Arn),
 * 			TenantId:      pulumi.String("example.okta.com"),
 * 			IngestionType: pulumi.String("auditLog"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appfabric.Ingestion;
 * import com.pulumi.aws.appfabric.IngestionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Ingestion("example", IngestionArgs.builder()
 *             .app("OKTA")
 *             .appBundleArn(exampleAwsAppfabricAppBundle.arn())
 *             .tenantId("example.okta.com")
 *             .ingestionType("auditLog")
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appfabric:Ingestion
 *     properties:
 *       app: OKTA
 *       appBundleArn: ${exampleAwsAppfabricAppBundle.arn}
 *       tenantId: example.okta.com
 *       ingestionType: auditLog
 *       tags:
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppFabric Ingestion using the `app_bundle_identifier` and `arn` separated by `,`. For example:
 * ```sh
 * $ pulumi import aws:appfabric/ingestion:Ingestion example arn:aws:appfabric:[region]:[account]:appbundle/a9b91477-8831-43c0-970c-xxxxxxxxxx,arn:aws:appfabric:[region]:[account]:appbundle/a9b91477-8831-43c0-970c-xxxxxxxxxx/ingestion/32251416-710b-4425-96ca-xxxxxxxxxx
 * ```
 */
public class Ingestion internal constructor(
    override val javaResource: com.pulumi.aws.appfabric.Ingestion,
) : KotlinCustomResource(javaResource, IngestionMapper) {
    /**
     * Name of the application.
     * Refer to the AWS Documentation for the [list of valid values](https://docs.aws.amazon.com/appfabric/latest/api/API_CreateIngestion.html#appfabric-CreateIngestion-request-app)
     */
    public val app: Output<String>
        get() = javaResource.app().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    public val appBundleArn: Output<String>
        get() = javaResource.appBundleArn().applyValue({ args0 -> args0 })

    /**
     * ARN of the Ingestion.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Ingestion type. Valid values are `auditLog`.
     */
    public val ingestionType: Output<String>
        get() = javaResource.ingestionType().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * ID of the application tenant.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })
}

public object IngestionMapper : ResourceMapper<Ingestion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appfabric.Ingestion::class == javaResource::class

    override fun map(javaResource: Resource): Ingestion = Ingestion(
        javaResource as
            com.pulumi.aws.appfabric.Ingestion,
    )
}

/**
 * @see [Ingestion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ingestion].
 */
public suspend fun ingestion(name: String, block: suspend IngestionResourceBuilder.() -> Unit): Ingestion {
    val builder = IngestionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ingestion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ingestion(name: String): Ingestion {
    val builder = IngestionResourceBuilder()
    builder.name(name)
    return builder.build()
}
