@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin

import com.pulumi.aws.appfabric.IngestionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS AppFabric Ingestion.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appfabric.Ingestion("example", {
 *     app: "OKTA",
 *     appBundleArn: exampleAwsAppfabricAppBundle.arn,
 *     tenantId: "example.okta.com",
 *     ingestionType: "auditLog",
 *     tags: {
 *         Environment: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appfabric.Ingestion("example",
 *     app="OKTA",
 *     app_bundle_arn=example_aws_appfabric_app_bundle["arn"],
 *     tenant_id="example.okta.com",
 *     ingestion_type="auditLog",
 *     tags={
 *         "Environment": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppFabric.Ingestion("example", new()
 *     {
 *         App = "OKTA",
 *         AppBundleArn = exampleAwsAppfabricAppBundle.Arn,
 *         TenantId = "example.okta.com",
 *         IngestionType = "auditLog",
 *         Tags =
 *         {
 *             { "Environment", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appfabric"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appfabric.NewIngestion(ctx, "example", &appfabric.IngestionArgs{
 * 			App:           pulumi.String("OKTA"),
 * 			AppBundleArn:  pulumi.Any(exampleAwsAppfabricAppBundle.Arn),
 * 			TenantId:      pulumi.String("example.okta.com"),
 * 			IngestionType: pulumi.String("auditLog"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appfabric.Ingestion;
 * import com.pulumi.aws.appfabric.IngestionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Ingestion("example", IngestionArgs.builder()
 *             .app("OKTA")
 *             .appBundleArn(exampleAwsAppfabricAppBundle.arn())
 *             .tenantId("example.okta.com")
 *             .ingestionType("auditLog")
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appfabric:Ingestion
 *     properties:
 *       app: OKTA
 *       appBundleArn: ${exampleAwsAppfabricAppBundle.arn}
 *       tenantId: example.okta.com
 *       ingestionType: auditLog
 *       tags:
 *         Environment: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppFabric Ingestion using the `app_bundle_identifier` and `arn` separated by `,`. For example:
 * ```sh
 * $ pulumi import aws:appfabric/ingestion:Ingestion example arn:aws:appfabric:[region]:[account]:appbundle/a9b91477-8831-43c0-970c-xxxxxxxxxx,arn:aws:appfabric:[region]:[account]:appbundle/a9b91477-8831-43c0-970c-xxxxxxxxxx/ingestion/32251416-710b-4425-96ca-xxxxxxxxxx
 * ```
 * @property app Name of the application.
 * Refer to the AWS Documentation for the [list of valid values](https://docs.aws.amazon.com/appfabric/latest/api/API_CreateIngestion.html#appfabric-CreateIngestion-request-app)
 * @property appBundleArn Amazon Resource Name (ARN) of the app bundle to use for the request.
 * @property ingestionType Ingestion type. Valid values are `auditLog`.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tenantId ID of the application tenant.
 */
public data class IngestionArgs(
    public val app: Output<String>? = null,
    public val appBundleArn: Output<String>? = null,
    public val ingestionType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appfabric.IngestionArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.IngestionArgs =
        com.pulumi.aws.appfabric.IngestionArgs.builder()
            .app(app?.applyValue({ args0 -> args0 }))
            .appBundleArn(appBundleArn?.applyValue({ args0 -> args0 }))
            .ingestionType(ingestionType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IngestionArgs].
 */
@PulumiTagMarker
public class IngestionArgsBuilder internal constructor() {
    private var app: Output<String>? = null

    private var appBundleArn: Output<String>? = null

    private var ingestionType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Name of the application.
     * Refer to the AWS Documentation for the [list of valid values](https://docs.aws.amazon.com/appfabric/latest/api/API_CreateIngestion.html#appfabric-CreateIngestion-request-app)
     */
    @JvmName("invfatltruljuxot")
    public suspend fun app(`value`: Output<String>) {
        this.app = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    @JvmName("kciyejntpiviwiol")
    public suspend fun appBundleArn(`value`: Output<String>) {
        this.appBundleArn = value
    }

    /**
     * @param value Ingestion type. Valid values are `auditLog`.
     */
    @JvmName("vhuvprktfklqgaii")
    public suspend fun ingestionType(`value`: Output<String>) {
        this.ingestionType = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("svekvwtikpbsyhkb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID of the application tenant.
     */
    @JvmName("uyfukoejcfjasqpn")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Name of the application.
     * Refer to the AWS Documentation for the [list of valid values](https://docs.aws.amazon.com/appfabric/latest/api/API_CreateIngestion.html#appfabric-CreateIngestion-request-app)
     */
    @JvmName("kkdnyicxcqbqtiwt")
    public suspend fun app(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.app = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    @JvmName("lqxqurgygpeyuilq")
    public suspend fun appBundleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appBundleArn = mapped
    }

    /**
     * @param value Ingestion type. Valid values are `auditLog`.
     */
    @JvmName("ochxdjrnbgigkkmu")
    public suspend fun ingestionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionType = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gexbeeykktserumm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tvngpywyqmhrmail")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ID of the application tenant.
     */
    @JvmName("mhykdractnmvvkbc")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): IngestionArgs = IngestionArgs(
        app = app,
        appBundleArn = appBundleArn,
        ingestionType = ingestionType,
        tags = tags,
        tenantId = tenantId,
    )
}
