@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin

import com.pulumi.aws.appfabric.kotlin.outputs.IngestionDestinationDestinationConfiguration
import com.pulumi.aws.appfabric.kotlin.outputs.IngestionDestinationProcessingConfiguration
import com.pulumi.aws.appfabric.kotlin.outputs.IngestionDestinationTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.appfabric.kotlin.outputs.IngestionDestinationDestinationConfiguration.Companion.toKotlin as ingestionDestinationDestinationConfigurationToKotlin
import com.pulumi.aws.appfabric.kotlin.outputs.IngestionDestinationProcessingConfiguration.Companion.toKotlin as ingestionDestinationProcessingConfigurationToKotlin
import com.pulumi.aws.appfabric.kotlin.outputs.IngestionDestinationTimeouts.Companion.toKotlin as ingestionDestinationTimeoutsToKotlin

/**
 * Builder for [IngestionDestination].
 */
@PulumiTagMarker
public class IngestionDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IngestionDestinationArgs = IngestionDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IngestionDestinationArgsBuilder.() -> Unit) {
        val builder = IngestionDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IngestionDestination {
        val builtJavaResource = com.pulumi.aws.appfabric.IngestionDestination(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IngestionDestination(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS AppFabric Ingestion Destination.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appfabric.IngestionDestination("example", {
 *     appBundleArn: exampleAwsAppfabricAppBundle.arn,
 *     ingestionArn: exampleAwsAppfabricIngestion.arn,
 *     processingConfiguration: {
 *         auditLog: {
 *             format: "json",
 *             schema: "raw",
 *         },
 *     },
 *     destinationConfiguration: {
 *         auditLog: {
 *             destination: {
 *                 s3Bucket: {
 *                     bucketName: exampleAwsS3Bucket.bucket,
 *                 },
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appfabric.IngestionDestination("example",
 *     app_bundle_arn=example_aws_appfabric_app_bundle["arn"],
 *     ingestion_arn=example_aws_appfabric_ingestion["arn"],
 *     processing_configuration={
 *         "audit_log": {
 *             "format": "json",
 *             "schema": "raw",
 *         },
 *     },
 *     destination_configuration={
 *         "audit_log": {
 *             "destination": {
 *                 "s3_bucket": {
 *                     "bucket_name": example_aws_s3_bucket["bucket"],
 *                 },
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppFabric.IngestionDestination("example", new()
 *     {
 *         AppBundleArn = exampleAwsAppfabricAppBundle.Arn,
 *         IngestionArn = exampleAwsAppfabricIngestion.Arn,
 *         ProcessingConfiguration = new Aws.AppFabric.Inputs.IngestionDestinationProcessingConfigurationArgs
 *         {
 *             AuditLog = new Aws.AppFabric.Inputs.IngestionDestinationProcessingConfigurationAuditLogArgs
 *             {
 *                 Format = "json",
 *                 Schema = "raw",
 *             },
 *         },
 *         DestinationConfiguration = new Aws.AppFabric.Inputs.IngestionDestinationDestinationConfigurationArgs
 *         {
 *             AuditLog = new Aws.AppFabric.Inputs.IngestionDestinationDestinationConfigurationAuditLogArgs
 *             {
 *                 Destination = new Aws.AppFabric.Inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationArgs
 *                 {
 *                     S3Bucket = new Aws.AppFabric.Inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs
 *                     {
 *                         BucketName = exampleAwsS3Bucket.Bucket,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appfabric"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appfabric.NewIngestionDestination(ctx, "example", &appfabric.IngestionDestinationArgs{
 * 			AppBundleArn: pulumi.Any(exampleAwsAppfabricAppBundle.Arn),
 * 			IngestionArn: pulumi.Any(exampleAwsAppfabricIngestion.Arn),
 * 			ProcessingConfiguration: &appfabric.IngestionDestinationProcessingConfigurationArgs{
 * 				AuditLog: &appfabric.IngestionDestinationProcessingConfigurationAuditLogArgs{
 * 					Format: pulumi.String("json"),
 * 					Schema: pulumi.String("raw"),
 * 				},
 * 			},
 * 			DestinationConfiguration: &appfabric.IngestionDestinationDestinationConfigurationArgs{
 * 				AuditLog: &appfabric.IngestionDestinationDestinationConfigurationAuditLogArgs{
 * 					Destination: &appfabric.IngestionDestinationDestinationConfigurationAuditLogDestinationArgs{
 * 						S3Bucket: &appfabric.IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs{
 * 							BucketName: pulumi.Any(exampleAwsS3Bucket.Bucket),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appfabric.IngestionDestination;
 * import com.pulumi.aws.appfabric.IngestionDestinationArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationAuditLogArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IngestionDestination("example", IngestionDestinationArgs.builder()
 *             .appBundleArn(exampleAwsAppfabricAppBundle.arn())
 *             .ingestionArn(exampleAwsAppfabricIngestion.arn())
 *             .processingConfiguration(IngestionDestinationProcessingConfigurationArgs.builder()
 *                 .auditLog(IngestionDestinationProcessingConfigurationAuditLogArgs.builder()
 *                     .format("json")
 *                     .schema("raw")
 *                     .build())
 *                 .build())
 *             .destinationConfiguration(IngestionDestinationDestinationConfigurationArgs.builder()
 *                 .auditLog(IngestionDestinationDestinationConfigurationAuditLogArgs.builder()
 *                     .destination(IngestionDestinationDestinationConfigurationAuditLogDestinationArgs.builder()
 *                         .s3Bucket(IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs.builder()
 *                             .bucketName(exampleAwsS3Bucket.bucket())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appfabric:IngestionDestination
 *     properties:
 *       appBundleArn: ${exampleAwsAppfabricAppBundle.arn}
 *       ingestionArn: ${exampleAwsAppfabricIngestion.arn}
 *       processingConfiguration:
 *         auditLog:
 *           format: json
 *           schema: raw
 *       destinationConfiguration:
 *         auditLog:
 *           destination:
 *             s3Bucket:
 *               bucketName: ${exampleAwsS3Bucket.bucket}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class IngestionDestination internal constructor(
    override val javaResource: com.pulumi.aws.appfabric.IngestionDestination,
) : KotlinCustomResource(javaResource, IngestionDestinationMapper) {
    /**
     * The Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    public val appBundleArn: Output<String>
        get() = javaResource.appBundleArn().applyValue({ args0 -> args0 })

    /**
     * ARN of the Ingestion Destination.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Contains information about the destination of ingested data.
     */
    public val destinationConfiguration: Output<IngestionDestinationDestinationConfiguration>?
        get() = javaResource.destinationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ingestionDestinationDestinationConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the ingestion to use for the request.
     */
    public val ingestionArn: Output<String>
        get() = javaResource.ingestionArn().applyValue({ args0 -> args0 })

    /**
     * Contains information about how ingested data is processed.
     */
    public val processingConfiguration: Output<IngestionDestinationProcessingConfiguration>?
        get() = javaResource.processingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ingestionDestinationProcessingConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<IngestionDestinationTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ingestionDestinationTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object IngestionDestinationMapper : ResourceMapper<IngestionDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appfabric.IngestionDestination::class == javaResource::class

    override fun map(javaResource: Resource): IngestionDestination = IngestionDestination(
        javaResource
            as com.pulumi.aws.appfabric.IngestionDestination,
    )
}

/**
 * @see [IngestionDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IngestionDestination].
 */
public suspend fun ingestionDestination(
    name: String,
    block: suspend IngestionDestinationResourceBuilder.() -> Unit,
): IngestionDestination {
    val builder = IngestionDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IngestionDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ingestionDestination(name: String): IngestionDestination {
    val builder = IngestionDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
