@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin

import com.pulumi.aws.appfabric.IngestionDestinationArgs.builder
import com.pulumi.aws.appfabric.kotlin.inputs.IngestionDestinationDestinationConfigurationArgs
import com.pulumi.aws.appfabric.kotlin.inputs.IngestionDestinationDestinationConfigurationArgsBuilder
import com.pulumi.aws.appfabric.kotlin.inputs.IngestionDestinationProcessingConfigurationArgs
import com.pulumi.aws.appfabric.kotlin.inputs.IngestionDestinationProcessingConfigurationArgsBuilder
import com.pulumi.aws.appfabric.kotlin.inputs.IngestionDestinationTimeoutsArgs
import com.pulumi.aws.appfabric.kotlin.inputs.IngestionDestinationTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS AppFabric Ingestion Destination.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appfabric.IngestionDestination("example", {
 *     appBundleArn: exampleAwsAppfabricAppBundle.arn,
 *     ingestionArn: exampleAwsAppfabricIngestion.arn,
 *     processingConfiguration: {
 *         auditLog: {
 *             format: "json",
 *             schema: "raw",
 *         },
 *     },
 *     destinationConfiguration: {
 *         auditLog: {
 *             destination: {
 *                 s3Bucket: {
 *                     bucketName: exampleAwsS3Bucket.bucket,
 *                 },
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appfabric.IngestionDestination("example",
 *     app_bundle_arn=example_aws_appfabric_app_bundle["arn"],
 *     ingestion_arn=example_aws_appfabric_ingestion["arn"],
 *     processing_configuration={
 *         "audit_log": {
 *             "format": "json",
 *             "schema": "raw",
 *         },
 *     },
 *     destination_configuration={
 *         "audit_log": {
 *             "destination": {
 *                 "s3_bucket": {
 *                     "bucket_name": example_aws_s3_bucket["bucket"],
 *                 },
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppFabric.IngestionDestination("example", new()
 *     {
 *         AppBundleArn = exampleAwsAppfabricAppBundle.Arn,
 *         IngestionArn = exampleAwsAppfabricIngestion.Arn,
 *         ProcessingConfiguration = new Aws.AppFabric.Inputs.IngestionDestinationProcessingConfigurationArgs
 *         {
 *             AuditLog = new Aws.AppFabric.Inputs.IngestionDestinationProcessingConfigurationAuditLogArgs
 *             {
 *                 Format = "json",
 *                 Schema = "raw",
 *             },
 *         },
 *         DestinationConfiguration = new Aws.AppFabric.Inputs.IngestionDestinationDestinationConfigurationArgs
 *         {
 *             AuditLog = new Aws.AppFabric.Inputs.IngestionDestinationDestinationConfigurationAuditLogArgs
 *             {
 *                 Destination = new Aws.AppFabric.Inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationArgs
 *                 {
 *                     S3Bucket = new Aws.AppFabric.Inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs
 *                     {
 *                         BucketName = exampleAwsS3Bucket.Bucket,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appfabric"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appfabric.NewIngestionDestination(ctx, "example", &appfabric.IngestionDestinationArgs{
 * 			AppBundleArn: pulumi.Any(exampleAwsAppfabricAppBundle.Arn),
 * 			IngestionArn: pulumi.Any(exampleAwsAppfabricIngestion.Arn),
 * 			ProcessingConfiguration: &appfabric.IngestionDestinationProcessingConfigurationArgs{
 * 				AuditLog: &appfabric.IngestionDestinationProcessingConfigurationAuditLogArgs{
 * 					Format: pulumi.String("json"),
 * 					Schema: pulumi.String("raw"),
 * 				},
 * 			},
 * 			DestinationConfiguration: &appfabric.IngestionDestinationDestinationConfigurationArgs{
 * 				AuditLog: &appfabric.IngestionDestinationDestinationConfigurationAuditLogArgs{
 * 					Destination: &appfabric.IngestionDestinationDestinationConfigurationAuditLogDestinationArgs{
 * 						S3Bucket: &appfabric.IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs{
 * 							BucketName: pulumi.Any(exampleAwsS3Bucket.Bucket),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appfabric.IngestionDestination;
 * import com.pulumi.aws.appfabric.IngestionDestinationArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationAuditLogArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationArgs;
 * import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IngestionDestination("example", IngestionDestinationArgs.builder()
 *             .appBundleArn(exampleAwsAppfabricAppBundle.arn())
 *             .ingestionArn(exampleAwsAppfabricIngestion.arn())
 *             .processingConfiguration(IngestionDestinationProcessingConfigurationArgs.builder()
 *                 .auditLog(IngestionDestinationProcessingConfigurationAuditLogArgs.builder()
 *                     .format("json")
 *                     .schema("raw")
 *                     .build())
 *                 .build())
 *             .destinationConfiguration(IngestionDestinationDestinationConfigurationArgs.builder()
 *                 .auditLog(IngestionDestinationDestinationConfigurationAuditLogArgs.builder()
 *                     .destination(IngestionDestinationDestinationConfigurationAuditLogDestinationArgs.builder()
 *                         .s3Bucket(IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs.builder()
 *                             .bucketName(exampleAwsS3Bucket.bucket())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appfabric:IngestionDestination
 *     properties:
 *       appBundleArn: ${exampleAwsAppfabricAppBundle.arn}
 *       ingestionArn: ${exampleAwsAppfabricIngestion.arn}
 *       processingConfiguration:
 *         auditLog:
 *           format: json
 *           schema: raw
 *       destinationConfiguration:
 *         auditLog:
 *           destination:
 *             s3Bucket:
 *               bucketName: ${exampleAwsS3Bucket.bucket}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property appBundleArn The Amazon Resource Name (ARN) of the app bundle to use for the request.
 * @property destinationConfiguration Contains information about the destination of ingested data.
 * @property ingestionArn The Amazon Resource Name (ARN) of the ingestion to use for the request.
 * @property processingConfiguration Contains information about how ingested data is processed.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class IngestionDestinationArgs(
    public val appBundleArn: Output<String>? = null,
    public val destinationConfiguration: Output<IngestionDestinationDestinationConfigurationArgs>? =
        null,
    public val ingestionArn: Output<String>? = null,
    public val processingConfiguration: Output<IngestionDestinationProcessingConfigurationArgs>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<IngestionDestinationTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appfabric.IngestionDestinationArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.IngestionDestinationArgs =
        com.pulumi.aws.appfabric.IngestionDestinationArgs.builder()
            .appBundleArn(appBundleArn?.applyValue({ args0 -> args0 }))
            .destinationConfiguration(
                destinationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ingestionArn(ingestionArn?.applyValue({ args0 -> args0 }))
            .processingConfiguration(
                processingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IngestionDestinationArgs].
 */
@PulumiTagMarker
public class IngestionDestinationArgsBuilder internal constructor() {
    private var appBundleArn: Output<String>? = null

    private var destinationConfiguration: Output<IngestionDestinationDestinationConfigurationArgs>? =
        null

    private var ingestionArn: Output<String>? = null

    private var processingConfiguration: Output<IngestionDestinationProcessingConfigurationArgs>? =
        null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<IngestionDestinationTimeoutsArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    @JvmName("jmgbkgbyscjuwiqb")
    public suspend fun appBundleArn(`value`: Output<String>) {
        this.appBundleArn = value
    }

    /**
     * @param value Contains information about the destination of ingested data.
     */
    @JvmName("ewnvxlvtnchwarej")
    public suspend fun destinationConfiguration(`value`: Output<IngestionDestinationDestinationConfigurationArgs>) {
        this.destinationConfiguration = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the ingestion to use for the request.
     */
    @JvmName("wfpbvvslywaycyio")
    public suspend fun ingestionArn(`value`: Output<String>) {
        this.ingestionArn = value
    }

    /**
     * @param value Contains information about how ingested data is processed.
     */
    @JvmName("noujhupsglxamxkg")
    public suspend fun processingConfiguration(`value`: Output<IngestionDestinationProcessingConfigurationArgs>) {
        this.processingConfiguration = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iwosoqivquowyeql")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("oqmnwwegrdtlvkwq")
    public suspend fun timeouts(`value`: Output<IngestionDestinationTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the app bundle to use for the request.
     */
    @JvmName("sdrncpxyvjjvmvbf")
    public suspend fun appBundleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appBundleArn = mapped
    }

    /**
     * @param value Contains information about the destination of ingested data.
     */
    @JvmName("uuttxffgtathdbpv")
    public suspend fun destinationConfiguration(`value`: IngestionDestinationDestinationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationConfiguration = mapped
    }

    /**
     * @param argument Contains information about the destination of ingested data.
     */
    @JvmName("nyxdbuniwmphxxbo")
    public suspend fun destinationConfiguration(argument: suspend IngestionDestinationDestinationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = IngestionDestinationDestinationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destinationConfiguration = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the ingestion to use for the request.
     */
    @JvmName("vtrtobtihuoylnfh")
    public suspend fun ingestionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionArn = mapped
    }

    /**
     * @param value Contains information about how ingested data is processed.
     */
    @JvmName("vaixwytvofebwluf")
    public suspend fun processingConfiguration(`value`: IngestionDestinationProcessingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processingConfiguration = mapped
    }

    /**
     * @param argument Contains information about how ingested data is processed.
     */
    @JvmName("fflhdbegwfhmrcck")
    public suspend fun processingConfiguration(argument: suspend IngestionDestinationProcessingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = IngestionDestinationProcessingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.processingConfiguration = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vwbwqqfbioiphqmk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gqohwnxepwvlvgfy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("wshlucjgrwksfnen")
    public suspend fun timeouts(`value`: IngestionDestinationTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ytqwopuyxcrbgahp")
    public suspend fun timeouts(argument: suspend IngestionDestinationTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = IngestionDestinationTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): IngestionDestinationArgs = IngestionDestinationArgs(
        appBundleArn = appBundleArn,
        destinationConfiguration = destinationConfiguration,
        ingestionArn = ingestionArn,
        processingConfiguration = processingConfiguration,
        tags = tags,
        timeouts = timeouts,
    )
}
