@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.inputs

import com.pulumi.aws.appfabric.inputs.AppAuthorizationConnectionAuthRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property code The authorization code returned by the application after permission is granted in the application OAuth page (after clicking on the AuthURL)..
 * @property redirectUri The redirect URL that is specified in the AuthURL and the application client.
 */
public data class AppAuthorizationConnectionAuthRequestArgs(
    public val code: Output<String>,
    public val redirectUri: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appfabric.inputs.AppAuthorizationConnectionAuthRequestArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.inputs.AppAuthorizationConnectionAuthRequestArgs =
        com.pulumi.aws.appfabric.inputs.AppAuthorizationConnectionAuthRequestArgs.builder()
            .code(code.applyValue({ args0 -> args0 }))
            .redirectUri(redirectUri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppAuthorizationConnectionAuthRequestArgs].
 */
@PulumiTagMarker
public class AppAuthorizationConnectionAuthRequestArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var redirectUri: Output<String>? = null

    /**
     * @param value The authorization code returned by the application after permission is granted in the application OAuth page (after clicking on the AuthURL)..
     */
    @JvmName("howeqsrgfdllhppp")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value The redirect URL that is specified in the AuthURL and the application client.
     */
    @JvmName("heobiglfnvhhfrcv")
    public suspend fun redirectUri(`value`: Output<String>) {
        this.redirectUri = value
    }

    /**
     * @param value The authorization code returned by the application after permission is granted in the application OAuth page (after clicking on the AuthURL)..
     */
    @JvmName("dvgpknudxhurauip")
    public suspend fun code(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value The redirect URL that is specified in the AuthURL and the application client.
     */
    @JvmName("viaosmwonsmhmarq")
    public suspend fun redirectUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirectUri = mapped
    }

    internal fun build(): AppAuthorizationConnectionAuthRequestArgs =
        AppAuthorizationConnectionAuthRequestArgs(
            code = code ?: throw PulumiNullFieldException("code"),
            redirectUri = redirectUri ?: throw PulumiNullFieldException("redirectUri"),
        )
}
